/*
 * Decompiled with CFR 0.152.
 */
package org.opencarto.algo;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.simplify.DouglasPeuckerLineSimplifier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opencarto.algo.LineDensification;

public class GaussianSmoothing {
    private static Logger logger = Logger.getLogger(GaussianSmoothing.class.getName());

    public static LineString get(LineString ls, double s, double res) {
        if (ls.getCoordinates().length <= 2) {
            return ls;
        }
        if (ls.isClosed()) {
            logger.log(Level.WARNING, "Closed line not supported in gaussian smoothing");
            return ls;
        }
        Coordinate[] densifiedCoordinates = LineDensification.get(ls, 1.0).getCoordinates();
        int n = 7 * (int)s;
        double[] gc = new double[n + 1];
        double a = s * Math.sqrt(Math.PI * 2);
        double b = s * s * 2.0;
        for (int i = 0; i < n + 1; ++i) {
            gc[i] = Math.exp((double)(-i * i) / b) / a;
        }
        int nb = (int)ls.getLength();
        Coordinate[] out = new Coordinate[nb + 1];
        Coordinate c0 = densifiedCoordinates[0];
        Coordinate cN = densifiedCoordinates[nb];
        for (int i = 0; i < nb; ++i) {
            double x = 0.0;
            double y = 0.0;
            for (int j = -n; j <= n; ++j) {
                double dy;
                double dx;
                Coordinate c;
                int q = i + j;
                if (q < 0) {
                    c = densifiedCoordinates[-q];
                    dx = 2.0 * c0.x - c.x;
                    dy = 2.0 * c0.y - c.y;
                } else if (i + j > nb) {
                    c = densifiedCoordinates[2 * nb - q];
                    dx = 2.0 * cN.x - c.x;
                    dy = 2.0 * cN.y - c.y;
                } else {
                    c = densifiedCoordinates[q];
                    dx = c.x;
                    dy = c.y;
                }
                x += dx * gc[j >= 0 ? j : -j];
                y += dy * gc[j >= 0 ? j : -j];
            }
            out[i] = new Coordinate(x, y);
        }
        out[nb] = densifiedCoordinates[densifiedCoordinates.length - 1];
        if (res > 0.0) {
            DouglasPeuckerLineSimplifier dp = new DouglasPeuckerLineSimplifier(out);
            dp.setDistanceTolerance(res);
            return new GeometryFactory().createLineString(dp.simplify());
        }
        return new GeometryFactory().createLineString(out);
    }
}

