/*
 * Decompiled with CFR 0.152.
 */
package org.opencarto.algo;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;

public class LineDensification {
    public static LineString get(LineString line, double step) {
        Coordinate[] cs = line.getCoordinates();
        int nb = (int)(line.getLength() / step);
        Coordinate[] out = new Coordinate[nb + 1];
        double d = 0.0;
        double a = 0.0;
        int densIndex = 0;
        for (int i = 0; i < cs.length - 1; ++i) {
            Coordinate c0 = cs[i];
            Coordinate c1 = cs[i + 1];
            double dTot = c0.distance(c1);
            if (d <= dTot) {
                a = Math.atan2(c1.y - c0.y, c1.x - c0.x);
            }
            while (d <= dTot) {
                out[densIndex] = new Coordinate(c0.x + d * Math.cos(a), c0.y + d * Math.sin(a));
                ++densIndex;
                d += step;
            }
            d -= dTot;
        }
        out[nb] = cs[cs.length - 1];
        return new GeometryFactory().createLineString(out);
    }
}

