/*
 * Decompiled with CFR 0.152.
 */
package org.opencarto.algo;

import com.vividsolutions.jts.algorithm.ConvexHull;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import java.util.logging.Logger;
import org.opencarto.algo.Rotation;
import org.opencarto.algo.Scaling;
import org.opencarto.algo.centroid.Centroid;

public class SmallestSurroundingRectangle {
    public static Logger logger = Logger.getLogger(SmallestSurroundingRectangle.class.getName());

    public static Polygon get(Geometry geom) {
        return SmallestSurroundingRectangle.get(geom, geom.getFactory());
    }

    public static Polygon get(Geometry geom, GeometryFactory gf) {
        Geometry hull_ = new ConvexHull(geom).getConvexHull();
        if (!(hull_ instanceof Polygon)) {
            return null;
        }
        Polygon convHull = (Polygon)hull_;
        Coordinate c = Centroid.get((Geometry)geom).getCoordinate();
        Coordinate[] coords = convHull.getExteriorRing().getCoordinates();
        double minArea = Double.MAX_VALUE;
        double minAngle = 0.0;
        Polygon ssr = null;
        Coordinate ci = coords[0];
        for (int i = 0; i < coords.length - 1; ++i) {
            Coordinate cii = coords[i + 1];
            double angle = Math.atan2(cii.y - ci.y, cii.x - ci.x);
            Polygon rect = (Polygon)Rotation.get((Polygon)convHull, (Coordinate)c, (double)(-1.0 * angle), (GeometryFactory)gf).getEnvelope();
            double area = rect.getArea();
            if (area < minArea) {
                minArea = area;
                ssr = rect;
                minAngle = angle;
            }
            ci = cii;
        }
        return Rotation.get(ssr, (Coordinate)c, (double)minAngle, (GeometryFactory)gf);
    }

    public static Polygon get(Geometry geom, boolean preserveSize) {
        return SmallestSurroundingRectangle.get(geom, geom.getFactory(), preserveSize);
    }

    public static Polygon get(Geometry geom, GeometryFactory gf, boolean preserveSize) {
        if (!preserveSize) {
            return SmallestSurroundingRectangle.get(geom, gf);
        }
        Polygon out = SmallestSurroundingRectangle.get(geom, gf);
        double ini = geom.getArea();
        double fin = out.getArea();
        if (fin == 0.0) {
            logger.warning("Failed to preserve size of smallest surrounding rectangle: Null final area.");
            return out;
        }
        return Scaling.get((Polygon)out, (Coordinate)Centroid.get((Geometry)out).getCoordinate(), (double)Math.sqrt(ini / fin), (GeometryFactory)gf);
    }
}

