/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core;

import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.TaskRegistrar;
import org.openstreetmap.osmosis.core.cli.CommandLineParser;
import org.openstreetmap.osmosis.core.pipeline.common.Pipeline;

public final class Osmosis {
    private static final Logger LOG = Logger.getLogger(Osmosis.class.getName());

    private Osmosis() {
    }

    public static void main(String[] args) {
        try {
            Osmosis.run(args);
            System.exit(0);
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, "Execution aborted.", t);
        }
        System.exit(1);
    }

    public static void run(String[] args) {
        long startTime = System.currentTimeMillis();
        Osmosis.configureLoggingConsole();
        CommandLineParser commandLineParser = new CommandLineParser();
        commandLineParser.parse(args);
        Osmosis.configureLoggingLevel(commandLineParser.getLogLevel());
        LOG.info("Osmosis Version 0.39");
        TaskRegistrar taskRegistrar = new TaskRegistrar();
        taskRegistrar.initialize(commandLineParser.getPlugins());
        Pipeline pipeline = new Pipeline(taskRegistrar.getFactoryRegister());
        LOG.info("Preparing pipeline.");
        pipeline.prepare(commandLineParser.getTaskInfoList());
        LOG.info("Launching pipeline execution.");
        pipeline.execute();
        LOG.info("Pipeline executing, waiting for completion.");
        pipeline.waitForCompletion();
        LOG.info("Pipeline complete.");
        long finishTime = System.currentTimeMillis();
        LOG.info("Total execution time: " + (finishTime - startTime) + " milliseconds.");
    }

    private static void configureLoggingConsole() {
        Logger rootLogger = Logger.getLogger("");
        for (Handler handler : rootLogger.getHandlers()) {
            rootLogger.removeHandler(handler);
        }
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.ALL);
        rootLogger.addHandler(consoleHandler);
    }

    private static void configureLoggingLevel(Level level) {
        Logger rootLogger = Logger.getLogger("");
        rootLogger.setLevel(level);
        Logger.getLogger("org.java.plugin").setLevel(Level.WARNING);
    }
}

