/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.buffer.v0_6;

import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.store.DataPostbox;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.core.task.v0_6.SinkRunnableSource;

public class EntityBuffer
implements SinkRunnableSource {
    private Sink sink;
    private DataPostbox<EntityContainer> buffer;

    public EntityBuffer(int bufferCapacity) {
        this.buffer = new DataPostbox(bufferCapacity);
    }

    @Override
    public void process(EntityContainer entityContainer) {
        this.buffer.put(entityContainer);
    }

    @Override
    public void complete() {
        this.buffer.complete();
    }

    @Override
    public void release() {
        this.buffer.release();
    }

    @Override
    public void setSink(Sink sink) {
        this.sink = sink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean completed = false;
        try {
            while (this.buffer.hasNext()) {
                this.sink.process(this.buffer.getNext());
            }
            this.sink.complete();
            completed = true;
        }
        finally {
            if (!completed) {
                this.buffer.setOutputError();
            }
            this.sink.release();
        }
    }
}

