/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.database;

import java.io.File;
import org.openstreetmap.osmosis.core.database.AuthenticationPropertiesLoader;
import org.openstreetmap.osmosis.core.database.DatabaseConstants;
import org.openstreetmap.osmosis.core.database.DatabaseLoginCredentials;
import org.openstreetmap.osmosis.core.database.DatabasePreferences;
import org.openstreetmap.osmosis.core.pipeline.common.TaskConfiguration;
import org.openstreetmap.osmosis.core.pipeline.common.TaskManagerFactory;

public abstract class DatabaseTaskManagerFactory
extends TaskManagerFactory {
    protected DatabaseLoginCredentials getDatabaseLoginCredentials(TaskConfiguration taskConfig) {
        DatabaseLoginCredentials loginCredentials = new DatabaseLoginCredentials("localhost", "osm", "osm", "", false, false, DatabaseConstants.TASK_DEFAULT_DB_TYPE);
        if (this.doesArgumentExist(taskConfig, "authFile")) {
            AuthenticationPropertiesLoader authLoader = new AuthenticationPropertiesLoader(new File(this.getStringArgument(taskConfig, "authFile")));
            authLoader.updateLoginCredentials(loginCredentials);
        }
        loginCredentials.setHost(this.getStringArgument(taskConfig, "host", loginCredentials.getHost()));
        loginCredentials.setDatabase(this.getStringArgument(taskConfig, "database", loginCredentials.getDatabase()));
        loginCredentials.setUser(this.getStringArgument(taskConfig, "user", loginCredentials.getUser()));
        loginCredentials.setPassword(this.getStringArgument(taskConfig, "password", loginCredentials.getPassword()));
        loginCredentials.setForceUtf8(this.getBooleanArgument(taskConfig, "forceUtf8", loginCredentials.getForceUtf8()));
        loginCredentials.setProfileSql(this.getBooleanArgument(taskConfig, "profileSql", loginCredentials.getProfileSql()));
        loginCredentials.setDbType(this.getStringArgument(taskConfig, "dbType", loginCredentials.getDbType().toString()));
        return loginCredentials;
    }

    protected DatabasePreferences getDatabasePreferences(TaskConfiguration taskConfig) {
        DatabasePreferences preferences = new DatabasePreferences(true, false);
        preferences.setValidateSchemaVersion(this.getBooleanArgument(taskConfig, "validateSchemaVersion", preferences.getValidateSchemaVersion()));
        preferences.setAllowIncorrectSchemaVersion(this.getBooleanArgument(taskConfig, "allowIncorrectSchemaVersion", preferences.getAllowIncorrectSchemaVersion()));
        return preferences;
    }
}

