/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.domain.common;

import java.util.Date;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.domain.common.TimestampContainer;
import org.openstreetmap.osmosis.core.domain.common.TimestampFormat;

public class UnparsedTimestampContainer
implements TimestampContainer {
    private TimestampFormat managedTimestampFormat;
    private String timestampString;
    private Date timestamp;

    public UnparsedTimestampContainer(TimestampFormat timestampFormat, String timestampString) {
        this.managedTimestampFormat = timestampFormat;
        this.timestampString = timestampString;
        if (timestampString == null) {
            throw new OsmosisRuntimeException("The entity timestamp attribute is missing.");
        }
    }

    @Override
    public String getFormattedTimestamp(TimestampFormat timestampFormat) {
        if (this.timestampString != null && this.managedTimestampFormat.isEquivalent(timestampFormat)) {
            return this.timestampString;
        }
        this.getTimestamp();
        if (this.timestamp != null) {
            return timestampFormat.formatTimestamp(this.timestamp);
        }
        return "";
    }

    @Override
    public Date getTimestamp() {
        if (this.timestamp == null && this.timestampString != null && this.timestampString.length() > 0) {
            this.timestamp = this.managedTimestampFormat.parseTimestamp(this.timestampString);
        }
        return this.timestamp;
    }
}

