/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.domain.v0_6;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.domain.common.SimpleTimestampContainer;
import org.openstreetmap.osmosis.core.domain.common.TimestampContainer;
import org.openstreetmap.osmosis.core.domain.common.TimestampFormat;
import org.openstreetmap.osmosis.core.domain.v0_6.OsmUser;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.domain.v0_6.TagCollection;
import org.openstreetmap.osmosis.core.domain.v0_6.TagCollectionImpl;
import org.openstreetmap.osmosis.core.domain.v0_6.UnmodifiableTagCollection;
import org.openstreetmap.osmosis.core.store.StoreClassRegister;
import org.openstreetmap.osmosis.core.store.StoreReader;
import org.openstreetmap.osmosis.core.store.StoreWriter;
import org.openstreetmap.osmosis.core.store.Storeable;
import org.openstreetmap.osmosis.core.util.LongAsInt;

public class CommonEntityData
implements Storeable {
    private long id;
    private int version;
    private int changesetId;
    private TimestampContainer timestampContainer;
    private OsmUser user;
    private TagCollection tags;
    private boolean readOnly;

    public CommonEntityData(long id, int version, Date timestamp, OsmUser user, long changesetId) {
        this(id, version, new SimpleTimestampContainer(timestamp), user, changesetId);
    }

    public CommonEntityData(long id, int version, TimestampContainer timestampContainer, OsmUser user, long changesetId) {
        this.init(id, timestampContainer, user, version, changesetId);
        this.tags = new TagCollectionImpl();
    }

    public CommonEntityData(long id, int version, Date timestamp, OsmUser user, long changesetId, Collection<Tag> tags) {
        this(id, version, new SimpleTimestampContainer(timestamp), user, changesetId, tags);
    }

    public CommonEntityData(long id, int version, TimestampContainer timestampContainer, OsmUser user, long changesetId, Collection<Tag> tags) {
        this.init(id, timestampContainer, user, version, changesetId);
        this.tags = new TagCollectionImpl((Collection<? extends Tag>)tags);
    }

    private void init(long newId, TimestampContainer newTimestampContainer, OsmUser newUser, int newVersion, long newChangesetId) {
        this.id = newId;
        this.timestampContainer = newTimestampContainer;
        this.user = newUser;
        this.version = newVersion;
        this.changesetId = LongAsInt.longToInt(newChangesetId);
    }

    private static TimestampContainer readTimestampContainer(StoreReader sr, StoreClassRegister scr) {
        if (sr.readBoolean()) {
            return new SimpleTimestampContainer(new Date(sr.readLong()));
        }
        return null;
    }

    private static OsmUser readOsmUser(StoreReader sr, StoreClassRegister scr) {
        OsmUser user = new OsmUser(sr, scr);
        if (user.equals(OsmUser.NONE)) {
            return OsmUser.NONE;
        }
        return user;
    }

    public CommonEntityData(StoreReader sr, StoreClassRegister scr) {
        this(sr.readLong(), sr.readInteger(), CommonEntityData.readTimestampContainer(sr, scr), CommonEntityData.readOsmUser(sr, scr), (long)sr.readInteger(), (Collection<Tag>)new TagCollectionImpl(sr, scr));
    }

    @Override
    public void store(StoreWriter sw, StoreClassRegister scr) {
        sw.writeLong(this.id);
        sw.writeInteger(this.version);
        if (this.getTimestamp() != null) {
            sw.writeBoolean(true);
            sw.writeLong(this.timestampContainer.getTimestamp().getTime());
        } else {
            sw.writeBoolean(false);
        }
        this.user.store(sw, scr);
        sw.writeInteger(this.changesetId);
        this.tags.store(sw, scr);
    }

    protected int compareTags(Collection<Tag> comparisonTags) {
        ArrayList<Tag> tags1 = new ArrayList<Tag>(this.tags);
        ArrayList<Tag> tags2 = new ArrayList<Tag>(comparisonTags);
        Collections.sort(tags1);
        Collections.sort(tags2);
        if (tags1.size() != tags2.size()) {
            return tags1.size() - tags2.size();
        }
        for (int i = 0; i < tags1.size(); ++i) {
            int result = ((Tag)tags1.get(i)).compareTo((Tag)tags2.get(i));
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.assertWriteable();
        this.id = id;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.assertWriteable();
        this.version = version;
    }

    public Date getTimestamp() {
        return this.timestampContainer.getTimestamp();
    }

    public void setTimestamp(Date timestamp) {
        this.assertWriteable();
        this.timestampContainer = new SimpleTimestampContainer(timestamp);
    }

    public TimestampContainer getTimestampContainer() {
        return this.timestampContainer;
    }

    public void setTimestampContainer(TimestampContainer timestampContainer) {
        this.assertWriteable();
        this.timestampContainer = timestampContainer;
    }

    public String getFormattedTimestamp(TimestampFormat timestampFormat) {
        return this.timestampContainer.getFormattedTimestamp(timestampFormat);
    }

    public OsmUser getUser() {
        return this.user;
    }

    public void setUser(OsmUser user) {
        this.assertWriteable();
        this.user = user;
    }

    public long getChangesetId() {
        return this.changesetId;
    }

    public void setChangesetId(long changesetId) {
        this.assertWriteable();
        this.changesetId = LongAsInt.longToInt(changesetId);
    }

    public Collection<Tag> getTags() {
        return this.tags;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected void assertWriteable() {
        if (this.readOnly) {
            throw new OsmosisRuntimeException("The object has been marked as read-only.  It must be cloned to make changes.");
        }
    }

    public void makeReadOnly() {
        if (!this.readOnly) {
            this.tags = new UnmodifiableTagCollection(this.tags);
            this.readOnly = true;
        }
    }

    public CommonEntityData getWriteableInstance() {
        return new CommonEntityData(this.id, this.version, this.timestampContainer, this.user, (long)this.changesetId, (Collection<Tag>)this.tags);
    }
}

