/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.domain.v0_6;

import java.util.Collection;
import java.util.Date;
import org.openstreetmap.osmosis.core.domain.common.TimestampContainer;
import org.openstreetmap.osmosis.core.domain.common.TimestampFormat;
import org.openstreetmap.osmosis.core.domain.v0_6.CommonEntityData;
import org.openstreetmap.osmosis.core.domain.v0_6.EntityType;
import org.openstreetmap.osmosis.core.domain.v0_6.OsmUser;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.store.StoreClassRegister;
import org.openstreetmap.osmosis.core.store.StoreReader;
import org.openstreetmap.osmosis.core.store.StoreWriter;
import org.openstreetmap.osmosis.core.store.Storeable;

public abstract class Entity
implements Storeable {
    private CommonEntityData entityData;

    public Entity(long id, int version, Date timestamp, OsmUser user, long changesetId) {
        this.entityData = new CommonEntityData(id, version, timestamp, user, changesetId);
    }

    public Entity(long id, int version, TimestampContainer timestampContainer, OsmUser user, long changesetId) {
        this.entityData = new CommonEntityData(id, version, timestampContainer, user, changesetId);
    }

    public Entity(long id, int version, Date timestamp, OsmUser user, long changesetId, Collection<Tag> tags) {
        this.entityData = new CommonEntityData(id, version, timestamp, user, changesetId, tags);
    }

    public Entity(long id, int version, TimestampContainer timestampContainer, OsmUser user, long changesetId, Collection<Tag> tags) {
        this.entityData = new CommonEntityData(id, version, timestampContainer, user, changesetId, tags);
    }

    public Entity(CommonEntityData entityData) {
        this.entityData = entityData;
    }

    public Entity(StoreReader sr, StoreClassRegister scr) {
        this.entityData = new CommonEntityData(sr, scr);
    }

    @Override
    public void store(StoreWriter sw, StoreClassRegister scr) {
        this.entityData.store(sw, scr);
    }

    protected int compareTags(Collection<Tag> comparisonTags) {
        return this.entityData.compareTags(comparisonTags);
    }

    public abstract EntityType getType();

    public long getId() {
        return this.entityData.getId();
    }

    public void setId(long id) {
        this.entityData.setId(id);
    }

    public int getVersion() {
        return this.entityData.getVersion();
    }

    public void setVersion(int version) {
        this.entityData.setVersion(version);
    }

    public Date getTimestamp() {
        return this.entityData.getTimestamp();
    }

    public void setTimestamp(Date timestamp) {
        this.entityData.setTimestamp(timestamp);
    }

    public TimestampContainer getTimestampContainer() {
        return this.entityData.getTimestampContainer();
    }

    public void setTimestampContainer(TimestampContainer timestampContainer) {
        this.entityData.setTimestampContainer(timestampContainer);
    }

    public String getFormattedTimestamp(TimestampFormat timestampFormat) {
        return this.entityData.getFormattedTimestamp(timestampFormat);
    }

    public OsmUser getUser() {
        return this.entityData.getUser();
    }

    public void setUser(OsmUser user) {
        this.entityData.setUser(user);
    }

    public long getChangesetId() {
        return this.entityData.getChangesetId();
    }

    public void setChangesetId(long changesetId) {
        this.entityData.setChangesetId(changesetId);
    }

    public Collection<Tag> getTags() {
        return this.entityData.getTags();
    }

    public boolean isReadOnly() {
        return this.entityData.isReadOnly();
    }

    protected void assertWriteable() {
        this.entityData.assertWriteable();
    }

    public void makeReadOnly() {
        this.entityData.makeReadOnly();
    }

    public abstract Entity getWriteableInstance();
}

