/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.domain.v0_6;

import java.util.Collection;
import java.util.Date;
import org.openstreetmap.osmosis.core.domain.common.SimpleTimestampContainer;
import org.openstreetmap.osmosis.core.domain.common.TimestampContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.CommonEntityData;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.EntityType;
import org.openstreetmap.osmosis.core.domain.v0_6.OsmUser;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.store.StoreClassRegister;
import org.openstreetmap.osmosis.core.store.StoreReader;
import org.openstreetmap.osmosis.core.store.StoreWriter;
import org.openstreetmap.osmosis.core.util.FixedPrecisionCoordinateConvertor;

public class Node
extends Entity
implements Comparable<Node> {
    private double latitude;
    private double longitude;

    public Node(long id, int version, Date timestamp, OsmUser user, long changesetId, double latitude, double longitude) {
        this(id, version, new SimpleTimestampContainer(timestamp), user, changesetId, latitude, longitude);
    }

    public Node(long id, int version, TimestampContainer timestampContainer, OsmUser user, long changesetId, double latitude, double longitude) {
        super(id, version, timestampContainer, user, changesetId);
        this.init(latitude, longitude);
    }

    public Node(CommonEntityData entityData, double latitude, double longitude) {
        super(entityData);
        this.init(latitude, longitude);
    }

    public Node(long id, int version, Date timestamp, OsmUser user, long changesetId, Collection<Tag> tags, double latitude, double longitude) {
        this(id, version, new SimpleTimestampContainer(timestamp), user, changesetId, tags, latitude, longitude);
    }

    public Node(long id, int version, TimestampContainer timestampContainer, OsmUser user, long changesetId, Collection<Tag> tags, double latitude, double longitude) {
        super(id, version, timestampContainer, user, changesetId, tags);
        this.init(latitude, longitude);
    }

    private void init(double newLatitude, double newLongitude) {
        this.latitude = newLatitude;
        this.longitude = newLongitude;
    }

    public Node(StoreReader sr, StoreClassRegister scr) {
        super(sr, scr);
        this.latitude = FixedPrecisionCoordinateConvertor.convertToDouble(sr.readInteger());
        this.longitude = FixedPrecisionCoordinateConvertor.convertToDouble(sr.readInteger());
    }

    @Override
    public void store(StoreWriter sw, StoreClassRegister scr) {
        super.store(sw, scr);
        sw.writeInteger(FixedPrecisionCoordinateConvertor.convertToFixed(this.latitude));
        sw.writeInteger(FixedPrecisionCoordinateConvertor.convertToFixed(this.longitude));
    }

    @Override
    public EntityType getType() {
        return EntityType.Node;
    }

    public boolean equals(Object o) {
        if (o instanceof Node) {
            return this.compareTo((Node)o) == 0;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.getId() + this.getVersion();
    }

    @Override
    public int compareTo(Node comparisonNode) {
        int result;
        if (this.getId() < comparisonNode.getId()) {
            return -1;
        }
        if (this.getId() > comparisonNode.getId()) {
            return 1;
        }
        if (this.getVersion() < comparisonNode.getVersion()) {
            return -1;
        }
        if (this.getVersion() > comparisonNode.getVersion()) {
            return 1;
        }
        if (this.latitude < comparisonNode.latitude) {
            return -1;
        }
        if (this.latitude > comparisonNode.latitude) {
            return 1;
        }
        if (this.longitude < comparisonNode.longitude) {
            return -1;
        }
        if (this.longitude > comparisonNode.longitude) {
            return 1;
        }
        if (this.getTimestamp() == null && comparisonNode.getTimestamp() != null) {
            return -1;
        }
        if (this.getTimestamp() != null && comparisonNode.getTimestamp() == null) {
            return 1;
        }
        if (this.getTimestamp() != null && comparisonNode.getTimestamp() != null && (result = this.getTimestamp().compareTo(comparisonNode.getTimestamp())) != 0) {
            return result;
        }
        return this.compareTags(comparisonNode.getTags());
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.assertWriteable();
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.assertWriteable();
        this.longitude = longitude;
    }

    @Override
    public Node getWriteableInstance() {
        if (this.isReadOnly()) {
            return new Node(this.getId(), this.getVersion(), this.getTimestampContainer(), this.getUser(), this.getChangesetId(), this.getTags(), this.latitude, this.longitude);
        }
        return this;
    }

    public String toString() {
        String name = null;
        Collection<Tag> tags = this.getTags();
        for (Tag tag : tags) {
            if (tag.getKey() == null || !tag.getKey().equalsIgnoreCase("name")) continue;
            name = tag.getValue();
            break;
        }
        if (name != null) {
            return "Node(id=" + this.getId() + ", #tags=" + this.getTags().size() + ", name='" + name + "')";
        }
        return "Node(id=" + this.getId() + ", #tags=" + this.getTags().size() + ")";
    }
}

