/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.domain.v0_6;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.osmosis.core.domain.common.SimpleTimestampContainer;
import org.openstreetmap.osmosis.core.domain.common.TimestampContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.CommonEntityData;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.EntityType;
import org.openstreetmap.osmosis.core.domain.v0_6.OsmUser;
import org.openstreetmap.osmosis.core.domain.v0_6.RelationMember;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.store.StoreClassRegister;
import org.openstreetmap.osmosis.core.store.StoreReader;
import org.openstreetmap.osmosis.core.store.StoreWriter;

public class Relation
extends Entity
implements Comparable<Relation> {
    private List<RelationMember> members;

    public Relation(long id, int version, Date timestamp, OsmUser user, long changesetId) {
        this(id, version, new SimpleTimestampContainer(timestamp), user, changesetId);
    }

    public Relation(long id, int version, TimestampContainer timestampContainer, OsmUser user, long changesetId) {
        super(id, version, timestampContainer, user, changesetId);
        this.members = new ArrayList<RelationMember>();
    }

    public Relation(CommonEntityData entityData) {
        super(entityData);
        this.members = new ArrayList<RelationMember>();
    }

    public Relation(long id, int version, Date timestamp, OsmUser user, long changesetId, Collection<Tag> tags, List<RelationMember> members) {
        this(id, version, new SimpleTimestampContainer(timestamp), user, changesetId, tags, members);
    }

    public Relation(long id, int version, TimestampContainer timestampContainer, OsmUser user, long changesetId, Collection<Tag> tags, List<RelationMember> members) {
        super(id, version, timestampContainer, user, changesetId, tags);
        this.members = new ArrayList<RelationMember>(members);
    }

    public Relation(CommonEntityData entityData, List<RelationMember> members) {
        super(entityData);
        this.members = new ArrayList<RelationMember>(members);
    }

    public Relation(StoreReader sr, StoreClassRegister scr) {
        super(sr, scr);
        int featureCount = sr.readInteger();
        this.members = new ArrayList<RelationMember>();
        for (int i = 0; i < featureCount; ++i) {
            this.members.add(new RelationMember(sr, scr));
        }
    }

    @Override
    public void store(StoreWriter sw, StoreClassRegister scr) {
        super.store(sw, scr);
        sw.writeInteger(this.members.size());
        for (RelationMember relationMember : this.members) {
            relationMember.store(sw, scr);
        }
    }

    @Override
    public EntityType getType() {
        return EntityType.Relation;
    }

    public boolean equals(Object o) {
        if (o instanceof Relation) {
            return this.compareTo((Relation)o) == 0;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.getId() + this.getVersion();
    }

    protected int compareMemberList(Collection<RelationMember> comparisonMemberList) {
        if (this.members.size() != comparisonMemberList.size()) {
            return this.members.size() - comparisonMemberList.size();
        }
        Iterator<RelationMember> i = this.members.iterator();
        Iterator<RelationMember> j = comparisonMemberList.iterator();
        while (i.hasNext()) {
            int result = i.next().compareTo(j.next());
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    @Override
    public int compareTo(Relation comparisonRelation) {
        int result;
        if (this.getId() < comparisonRelation.getId()) {
            return -1;
        }
        if (this.getId() > comparisonRelation.getId()) {
            return 1;
        }
        if (this.getVersion() < comparisonRelation.getVersion()) {
            return -1;
        }
        if (this.getVersion() > comparisonRelation.getVersion()) {
            return 1;
        }
        if (this.getTimestamp() == null && comparisonRelation.getTimestamp() != null) {
            return -1;
        }
        if (this.getTimestamp() != null && comparisonRelation.getTimestamp() == null) {
            return 1;
        }
        if (this.getTimestamp() != null && comparisonRelation.getTimestamp() != null && (result = this.getTimestamp().compareTo(comparisonRelation.getTimestamp())) != 0) {
            return result;
        }
        int memberListResult = this.compareMemberList(comparisonRelation.members);
        if (memberListResult != 0) {
            return memberListResult;
        }
        return this.compareTags(comparisonRelation.getTags());
    }

    @Override
    public void makeReadOnly() {
        if (!this.isReadOnly()) {
            this.members = Collections.unmodifiableList(this.members);
        }
        super.makeReadOnly();
    }

    @Override
    public Relation getWriteableInstance() {
        if (this.isReadOnly()) {
            return new Relation(this.getId(), this.getVersion(), this.getTimestampContainer(), this.getUser(), this.getChangesetId(), this.getTags(), this.members);
        }
        return this;
    }

    public List<RelationMember> getMembers() {
        return this.members;
    }

    public String toString() {
        String type = null;
        Collection<Tag> tags = this.getTags();
        for (Tag tag : tags) {
            if (tag.getKey() == null || !tag.getKey().equalsIgnoreCase("type")) continue;
            type = tag.getValue();
            break;
        }
        if (type != null) {
            return "Relation(id=" + this.getId() + ", #tags=" + this.getTags().size() + ", type='" + type + "')";
        }
        return "Relation(id=" + this.getId() + ", #tags=" + this.getTags().size() + ")";
    }
}

