/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.progress.v0_6;

import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.container.v0_6.ChangeContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.progress.v0_6.impl.ProgressTracker;
import org.openstreetmap.osmosis.core.task.common.ChangeAction;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSink;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSinkChangeSource;

public class ChangeProgressLogger
implements ChangeSinkChangeSource {
    private static final Logger LOG = Logger.getLogger(ChangeProgressLogger.class.getName());
    private ChangeSink changeSink;
    private ProgressTracker progressTracker;

    public ChangeProgressLogger(int interval) {
        this.progressTracker = new ProgressTracker(interval);
    }

    @Override
    public void process(ChangeContainer changeContainer) {
        Entity entity = changeContainer.getEntityContainer().getEntity();
        ChangeAction action = changeContainer.getAction();
        if (this.progressTracker.updateRequired()) {
            LOG.info("Processing " + (Object)((Object)entity.getType()) + " " + entity.getId() + " with action " + (Object)((Object)action) + ", " + this.progressTracker.getObjectsPerSecond() + " objects/second.");
        }
        this.changeSink.process(changeContainer);
    }

    @Override
    public void complete() {
        LOG.info("Processing completion steps.");
        this.changeSink.complete();
        LOG.info("Processing complete.");
    }

    @Override
    public void release() {
        this.changeSink.release();
    }

    @Override
    public void setChangeSink(ChangeSink changeSink) {
        this.changeSink = changeSink;
    }
}

