/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.progress.v0_6;

import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.progress.v0_6.impl.ProgressTracker;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.core.task.v0_6.SinkSource;

public class EntityProgressLogger
implements SinkSource {
    private static final Logger LOG = Logger.getLogger(EntityProgressLogger.class.getName());
    private Sink sink;
    private ProgressTracker progressTracker;

    public EntityProgressLogger(int interval) {
        this.progressTracker = new ProgressTracker(interval);
    }

    @Override
    public void process(EntityContainer entityContainer) {
        Entity entity = entityContainer.getEntity();
        if (this.progressTracker.updateRequired()) {
            LOG.info("Processing " + (Object)((Object)entity.getType()) + " " + entity.getId() + ", " + this.progressTracker.getObjectsPerSecond() + " objects/second.");
        }
        this.sink.process(entityContainer);
    }

    @Override
    public void complete() {
        LOG.info("Processing completion steps.");
        this.sink.complete();
        LOG.info("Processing complete.");
    }

    @Override
    public void release() {
        this.sink.release();
    }

    @Override
    public void setSink(Sink sink) {
        this.sink = sink;
    }
}

