/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.progress.v0_6.impl;

public class ProgressTracker {
    private int interval;
    private boolean initialized;
    private long lastUpdateTimestamp;
    private long objectCount;
    private double objectsPerSecond;

    public ProgressTracker(int interval) {
        this.interval = interval;
        this.initialized = false;
    }

    public boolean updateRequired() {
        if (!this.initialized) {
            this.lastUpdateTimestamp = System.currentTimeMillis();
            this.objectCount = 0L;
            this.objectsPerSecond = 0.0;
            this.initialized = true;
            return false;
        }
        long currentTimestamp = System.currentTimeMillis();
        long duration = currentTimestamp - this.lastUpdateTimestamp;
        ++this.objectCount;
        if (duration > (long)this.interval || duration < 0L) {
            this.lastUpdateTimestamp = currentTimestamp;
            this.objectsPerSecond = (double)this.objectCount * 1000.0 / (double)duration;
            this.objectCount = 0L;
            return true;
        }
        return false;
    }

    public double getObjectsPerSecond() {
        return this.objectsPerSecond;
    }
}

