/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.sort.common;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;

public class MergingIterator<DataType>
implements ReleasableIterator<DataType> {
    private List<ReleasableIterator<DataType>> sources;
    private Comparator<DataType> comparator;
    private List<DataType> sourceData;

    public MergingIterator(List<ReleasableIterator<DataType>> sources, Comparator<DataType> comparator) {
        this.sources = new ArrayList<ReleasableIterator<DataType>>(sources);
        this.comparator = comparator;
    }

    private void initialize() {
        if (this.sourceData == null) {
            this.sourceData = new ArrayList<DataType>(this.sources.size());
            int sourceIndex = 0;
            while (sourceIndex < this.sources.size()) {
                ReleasableIterator<DataType> source = this.sources.get(sourceIndex);
                if (source.hasNext()) {
                    this.sourceData.add(source.next());
                    ++sourceIndex;
                    continue;
                }
                this.sources.remove(sourceIndex);
            }
        }
    }

    @Override
    public boolean hasNext() {
        this.initialize();
        return this.sourceData.size() > 0;
    }

    @Override
    public DataType next() {
        this.initialize();
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        DataType dataMinimum = this.sourceData.get(0);
        int indexMinimum = 0;
        for (int indexCurrent = 1; indexCurrent < this.sources.size(); ++indexCurrent) {
            DataType dataCurrent = this.sourceData.get(indexCurrent);
            if (this.comparator.compare(dataMinimum, dataCurrent) <= 0) continue;
            dataMinimum = dataCurrent;
            indexMinimum = indexCurrent;
        }
        ReleasableIterator<DataType> source = this.sources.get(indexMinimum);
        if (source.hasNext()) {
            this.sourceData.set(indexMinimum, source.next());
        } else {
            this.sources.remove(indexMinimum).release();
            this.sourceData.remove(indexMinimum);
        }
        return dataMinimum;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void release() {
        for (ReleasableIterator<DataType> source : this.sources) {
            source.release();
        }
    }
}

