/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.sort.v0_6;

import java.util.Comparator;
import org.openstreetmap.osmosis.core.container.v0_6.ChangeContainer;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.sort.common.FileBasedSort;
import org.openstreetmap.osmosis.core.store.SingleClassObjectSerializationFactory;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSink;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSinkChangeSource;

public class ChangeSorter
implements ChangeSinkChangeSource {
    private FileBasedSort<ChangeContainer> fileBasedSort;
    private ChangeSink changeSink;

    public ChangeSorter(Comparator<ChangeContainer> comparator) {
        this.fileBasedSort = new FileBasedSort<ChangeContainer>(new SingleClassObjectSerializationFactory(ChangeContainer.class), comparator, true);
    }

    @Override
    public void process(ChangeContainer change) {
        this.fileBasedSort.add(change);
    }

    @Override
    public void setChangeSink(ChangeSink changeSink) {
        this.changeSink = changeSink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete() {
        ReleasableIterator<ChangeContainer> iterator = null;
        try {
            iterator = this.fileBasedSort.iterate();
            while (iterator.hasNext()) {
                this.changeSink.process((ChangeContainer)iterator.next());
            }
            this.changeSink.complete();
        }
        finally {
            if (iterator != null) {
                iterator.release();
            }
        }
    }

    @Override
    public void release() {
        this.fileBasedSort.release();
        this.changeSink.release();
    }
}

