/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.sort.v0_6;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.core.task.v0_6.SinkSource;

public class TagSorter
implements SinkSource {
    private Sink sink;

    @Override
    public void process(EntityContainer entityContainer) {
        EntityContainer writeableContainer = entityContainer.getWriteableInstance();
        Entity entity = writeableContainer.getEntity();
        List<Tag> sortedTags = this.sortTags(entity.getTags());
        entity.getTags().clear();
        entity.getTags().addAll(sortedTags);
        this.sink.process(writeableContainer);
    }

    private List<Tag> sortTags(Collection<Tag> tagList) {
        ArrayList<Tag> sortedTagList = new ArrayList<Tag>(tagList);
        Collections.sort(sortedTagList);
        return sortedTagList;
    }

    @Override
    public void setSink(Sink sink) {
        this.sink = sink;
    }

    @Override
    public void complete() {
        this.sink.complete();
    }

    @Override
    public void release() {
        this.sink.release();
    }
}

