/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.store;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;

public class DataPostbox<T> {
    private int bufferCapacity;
    private int chunkSize;
    private Lock lock;
    private Condition dataWaitCondition;
    private Collection<T> centralQueue;
    private Collection<T> inboundQueue;
    private Queue<T> outboundQueue;
    private boolean released;
    private boolean complete;
    private boolean outputOkay;

    public DataPostbox(int capacity) {
        if (capacity <= 0) {
            throw new OsmosisRuntimeException("A capacity of " + capacity + " is invalid, must be greater than 0.");
        }
        this.bufferCapacity = capacity;
        this.chunkSize = this.bufferCapacity / 4;
        if (this.chunkSize <= 0) {
            this.chunkSize = 1;
        }
        this.lock = new ReentrantLock();
        this.dataWaitCondition = this.lock.newCondition();
        this.centralQueue = new ArrayList<T>();
        this.inboundQueue = new ArrayList<T>();
        this.outboundQueue = new ArrayDeque<T>();
        this.released = false;
        this.complete = false;
        this.outputOkay = true;
    }

    private void checkForOutputErrors() {
        if (!this.outputOkay) {
            throw new OsmosisRuntimeException("An output error has occurred, aborting.");
        }
    }

    private void checkForInputErrors() {
        if (this.released && !this.complete) {
            throw new OsmosisRuntimeException("An input error has occurred, aborting.");
        }
    }

    private void waitForUpdate() {
        try {
            this.dataWaitCondition.await();
        }
        catch (InterruptedException e) {
            throw new OsmosisRuntimeException("Thread was interrupted.", e);
        }
    }

    private void signalUpdate() {
        this.dataWaitCondition.signal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateCentralQueue() {
        this.lock.lock();
        try {
            this.checkForOutputErrors();
            while (this.centralQueue.size() >= this.bufferCapacity) {
                this.waitForUpdate();
                this.checkForOutputErrors();
            }
            this.centralQueue.addAll(this.inboundQueue);
            this.inboundQueue.clear();
            this.signalUpdate();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumeCentralQueue() {
        this.lock.lock();
        try {
            this.checkForInputErrors();
            while (this.centralQueue.size() <= 0 && !this.complete) {
                this.waitForUpdate();
                this.checkForInputErrors();
            }
            this.outboundQueue.addAll(this.centralQueue);
            this.centralQueue.clear();
            this.signalUpdate();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void put(T o) {
        this.inboundQueue.add(o);
        if (this.inboundQueue.size() >= this.chunkSize) {
            this.populateCentralQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() {
        this.lock.lock();
        try {
            this.populateCentralQueue();
            this.complete = true;
            this.signalUpdate();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        this.lock.lock();
        try {
            this.released = true;
            this.signalUpdate();
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean hasNext() {
        int queueSize = this.outboundQueue.size();
        if (queueSize <= 0) {
            this.consumeCentralQueue();
            queueSize = this.outboundQueue.size();
        }
        return queueSize > 0;
    }

    public T getNext() {
        if (this.hasNext()) {
            T result = this.outboundQueue.remove();
            return result;
        }
        throw new OsmosisRuntimeException("No data is available, should call hasNext first.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutputError() {
        this.lock.lock();
        try {
            this.outputOkay = false;
            this.signalUpdate();
        }
        finally {
            this.lock.unlock();
        }
    }
}

