/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.store;

import java.io.File;
import org.openstreetmap.osmosis.core.lifecycle.Completable;
import org.openstreetmap.osmosis.core.store.ComparableComparator;
import org.openstreetmap.osmosis.core.store.IndexStore;
import org.openstreetmap.osmosis.core.store.IndexStoreReader;
import org.openstreetmap.osmosis.core.store.IndexedObjectStoreReader;
import org.openstreetmap.osmosis.core.store.LongLongIndexElement;
import org.openstreetmap.osmosis.core.store.ObjectSerializationFactory;
import org.openstreetmap.osmosis.core.store.RandomAccessObjectStore;
import org.openstreetmap.osmosis.core.store.RandomAccessObjectStoreReader;
import org.openstreetmap.osmosis.core.store.Storeable;

public class IndexedObjectStore<T extends Storeable>
implements Completable {
    private RandomAccessObjectStore<T> objectStore;
    private IndexStore<Long, LongLongIndexElement> indexStore;

    public IndexedObjectStore(ObjectSerializationFactory serializationFactory, String tmpFilePrefix) {
        this.objectStore = new RandomAccessObjectStore(serializationFactory, tmpFilePrefix + "d");
        this.indexStore = new IndexStore(LongLongIndexElement.class, new ComparableComparator(), tmpFilePrefix + "i");
    }

    public IndexedObjectStore(ObjectSerializationFactory serializationFactory, File objectStorageFile, File indexStorageFile) {
        this.objectStore = new RandomAccessObjectStore(serializationFactory, objectStorageFile);
        this.indexStore = new IndexStore(LongLongIndexElement.class, new ComparableComparator(), indexStorageFile);
    }

    public void add(long id, T data) {
        long objectOffset = this.objectStore.add(data);
        this.indexStore.write(new LongLongIndexElement(id, objectOffset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexedObjectStoreReader<T> createReader() {
        RandomAccessObjectStoreReader<T> objectStoreReader = null;
        objectStoreReader = this.objectStore.createReader();
        try {
            IndexStoreReader<Long, LongLongIndexElement> indexStoreReader = this.indexStore.createReader();
            IndexedObjectStoreReader<T> reader = new IndexedObjectStoreReader<T>(objectStoreReader, indexStoreReader);
            objectStoreReader = null;
            IndexedObjectStoreReader<T> indexedObjectStoreReader = reader;
            return indexedObjectStoreReader;
        }
        finally {
            if (objectStoreReader != null) {
                objectStoreReader.release();
            }
        }
    }

    @Override
    public void complete() {
        this.objectStore.complete();
        this.indexStore.complete();
    }

    @Override
    public void release() {
        this.objectStore.release();
        this.indexStore.release();
    }
}

