/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.tee.v0_6;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.ChangeContainer;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSink;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSinkChangeSource;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSinkMultiChangeSource;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSource;

public class ChangeTee
implements ChangeSinkMultiChangeSource {
    private List<ProxyChangeSinkChangeSource> sinkList = new ArrayList<ProxyChangeSinkChangeSource>();

    public ChangeTee(int outputCount) {
        for (int i = 0; i < outputCount; ++i) {
            this.sinkList.add(new ProxyChangeSinkChangeSource());
        }
    }

    @Override
    public ChangeSource getChangeSource(int index) {
        if (index < 0 || index >= this.sinkList.size()) {
            throw new OsmosisRuntimeException("Source index " + index + " is in the range 0 to " + (this.sinkList.size() - 1) + ".");
        }
        return this.sinkList.get(index);
    }

    @Override
    public int getChangeSourceCount() {
        return this.sinkList.size();
    }

    @Override
    public void process(ChangeContainer change) {
        for (ProxyChangeSinkChangeSource sink : this.sinkList) {
            change.getEntityContainer().getEntity().makeReadOnly();
            sink.process(change);
        }
    }

    @Override
    public void complete() {
        for (ProxyChangeSinkChangeSource sink : this.sinkList) {
            sink.complete();
        }
    }

    @Override
    public void release() {
        for (ProxyChangeSinkChangeSource sink : this.sinkList) {
            sink.release();
        }
    }

    private static class ProxyChangeSinkChangeSource
    implements ChangeSinkChangeSource {
        private ChangeSink changeSink;

        @Override
        public void setChangeSink(ChangeSink changeSink) {
            this.changeSink = changeSink;
        }

        @Override
        public void process(ChangeContainer change) {
            this.changeSink.process(change);
        }

        @Override
        public void complete() {
            this.changeSink.complete();
        }

        @Override
        public void release() {
            this.changeSink.release();
        }
    }
}

