/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf.corba;

import com.bbn.openmap.Environment;
import com.bbn.openmap.layer.rpf.RpfCoverageBox;
import com.bbn.openmap.layer.rpf.RpfFrameProvider;
import com.bbn.openmap.layer.rpf.RpfIndexedImageData;
import com.bbn.openmap.layer.rpf.RpfViewAttributes;
import com.bbn.openmap.layer.rpf.corba.CRpfFrameProvider.CRFPCADRGProjection;
import com.bbn.openmap.layer.rpf.corba.CRpfFrameProvider.CRFPCoverageBox;
import com.bbn.openmap.layer.rpf.corba.CRpfFrameProvider.CRFPViewAttributes;
import com.bbn.openmap.layer.rpf.corba.CRpfFrameProvider.LLPoint;
import com.bbn.openmap.layer.rpf.corba.CRpfFrameProvider.RawImage;
import com.bbn.openmap.layer.rpf.corba.CRpfFrameProvider.Server;
import com.bbn.openmap.layer.rpf.corba.CRpfFrameProvider.ServerHelper;
import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.proj.CADRG;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import com.bbn.openmap.util.corba.CORBASupport;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;

public class CRFPClient
implements RpfFrameProvider {
    public static final String iorUrlProperty = "ior";
    public static final String nameProperty = "name";
    public static final String JPEGQualityProperty = "jpegQuality";
    protected transient Server server = null;
    protected String naming = null;
    protected URL iorURL = null;
    private String clientID = Environment.generateUniqueString();
    public float jpegQuality = 0.8f;

    public void setJpegQuality(float jq) {
        this.jpegQuality = jq;
    }

    public float getJpegQuality() {
        return this.jpegQuality;
    }

    public void setNaming(String CORBAName) {
        this.naming = CORBAName;
    }

    public String getNaming() {
        return this.naming;
    }

    public void setIorURL(URL iorurl) {
        this.iorURL = iorurl;
    }

    public URL getIorURL() {
        return this.iorURL;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setProperties(String prefix, Properties properties) {
        prefix = PropUtils.getScopedPropertyPrefix((String)prefix);
        this.jpegQuality = PropUtils.floatFromProperties((Properties)properties, (String)(prefix + JPEGQualityProperty), (float)0.8f);
        String url = properties.getProperty(prefix + iorUrlProperty);
        if (url != null) {
            try {
                this.iorURL = PropUtils.getResourceOrFileOrURL((String)url);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("\"" + url + "\"" + " is malformed.");
            }
        }
        this.naming = properties.getProperty(prefix + nameProperty);
    }

    protected void finalize() {
        if (Debug.debugging((String)"crfp")) {
            Debug.output((String)"CRFPClient.finalize(): calling shutdown");
        }
        try {
            if (this.server != null) {
                this.server.signoff(this.clientID);
            }
            this.server = null;
        }
        catch (SystemException e) {
            Debug.error((String)("CRFPClient.finalize(): " + (java.lang.Object)((java.lang.Object)e)));
        }
        catch (Throwable t) {
            Debug.error((String)("CRFPClient.finalize(): " + t));
        }
    }

    public boolean needViewAttributeUpdates() {
        return true;
    }

    public void setViewAttributes(RpfViewAttributes rva) {
        Server serv = this.getServer();
        if (serv == null || rva == null) {
            return;
        }
        try {
            serv.setViewAttributes(new CRFPViewAttributes((short)rva.numberOfColors, (short)rva.opaqueness, rva.scaleImages, rva.imageScaleFactor, rva.chartSeries), this.clientID);
            Debug.message((String)"crfp", (String)"CRFPClient: setting attributes.");
        }
        catch (SystemException e) {
            this.handleCORBAError(e);
        }
    }

    public Vector getCoverage(float ullat, float ullon, float lrlat, float lrlon, Projection p) {
        Server serv = this.getServer();
        if (serv == null) {
            return new Vector();
        }
        Point2D center = p.getCenter();
        LLPoint llpoint = new LLPoint((float)center.getY(), (float)center.getX());
        CADRG cadrg = CADRG.convertProjection((Projection)p);
        CRFPCADRGProjection proj = new CRFPCADRGProjection(llpoint, (short)cadrg.getHeight(), (short)cadrg.getWidth(), cadrg.getScale(), (short)cadrg.getZone());
        Debug.message((String)"crfp", (String)"CRFPClient: getting coverage from server.");
        try {
            CRFPCoverageBox[] boxes = serv.getCoverage(ullat, ullon, lrlat, lrlon, proj, this.clientID);
            return this.translateCRFPCoverageBoxes(boxes);
        }
        catch (SystemException e) {
            this.handleCORBAError(e);
            return new Vector();
        }
    }

    public Vector getCatalogCoverage(float ullat, float ullon, float lrlat, float lrlon, Projection p, String chartSeriesCode) {
        Server serv = this.getServer();
        if (serv == null) {
            return new Vector();
        }
        Point2D center = p.getCenter();
        LLPoint llpoint = new LLPoint((float)center.getY(), (float)center.getX());
        CADRG cadrg = CADRG.convertProjection((Projection)p);
        CRFPCADRGProjection proj = new CRFPCADRGProjection(llpoint, (short)cadrg.getHeight(), (short)cadrg.getWidth(), cadrg.getScale(), (short)cadrg.getZone());
        Debug.message((String)"crfp", (String)"CRFPClient: getting catalog coverage from server.");
        try {
            CRFPCoverageBox[] boxes = serv.getCatalogCoverage(ullat, ullon, lrlat, lrlon, proj, chartSeriesCode, this.clientID);
            return this.translateCRFPCoverageBoxes(boxes);
        }
        catch (SystemException e) {
            this.handleCORBAError(e);
            return new Vector();
        }
    }

    public float getCalculatedCoverage(float ullat, float ullon, float lrlat, float lrlon, Projection p, String chartSeries) {
        int x;
        int y;
        RpfCoverageBox rcb;
        int i;
        if (chartSeries.equalsIgnoreCase("ANY")) {
            return 0.0f;
        }
        Vector results = this.getCatalogCoverage(ullat, ullon, lrlat, lrlon, p, chartSeries);
        int size = results.size();
        if (size == 0) {
            return 0.0f;
        }
        double frameLatInterval = Double.MAX_VALUE;
        double frameLonInterval = Double.MAX_VALUE;
        for (i = 0; i < size; ++i) {
            rcb = (RpfCoverageBox)results.elementAt(i);
            if (rcb.subframeLatInterval < frameLatInterval) {
                frameLatInterval = rcb.subframeLatInterval;
            }
            if (!(rcb.subframeLonInterval < frameLonInterval)) continue;
            frameLonInterval = rcb.subframeLonInterval;
        }
        if (frameLatInterval == Double.MAX_VALUE || frameLonInterval == Double.MAX_VALUE) {
            return 0.0f;
        }
        int numHFrames = (int)Math.ceil((double)(lrlon - ullon) / frameLonInterval);
        int numVFrames = (int)Math.ceil((double)(ullat - lrlat) / frameLatInterval);
        boolean[][] coverage = new boolean[numHFrames][numVFrames];
        for (i = 0; i < size; ++i) {
            rcb = (RpfCoverageBox)results.elementAt(i);
            if (rcb.percentCoverage == 100.0f) {
                return 1.0f;
            }
            for (y = 0; y < numVFrames; ++y) {
                for (x = 0; x < numHFrames; ++x) {
                    float yFrameLoc = (float)((double)lrlat + (double)y * frameLatInterval);
                    float xFrameLoc = (float)((double)ullon + (double)x * frameLonInterval);
                    if (coverage[x][y] || !rcb.within(yFrameLoc, xFrameLoc)) continue;
                    coverage[x][y] = true;
                }
            }
        }
        float count = 0.0f;
        for (y = 0; y < numVFrames; ++y) {
            for (x = 0; x < numHFrames; ++x) {
                if (!coverage[x][y]) continue;
                count += 1.0f;
            }
        }
        return count / (float)(numHFrames * numVFrames);
    }

    protected Vector translateCRFPCoverageBoxes(CRFPCoverageBox[] boxes) {
        Vector<RpfCoverageBox> vector = new Vector<RpfCoverageBox>();
        for (int i = 0; i < boxes.length; ++i) {
            CRFPCoverageBox box = boxes[i];
            RpfCoverageBox rcb = new RpfCoverageBox();
            rcb.nw_lat = box.nw_lat;
            rcb.nw_lon = box.nw_lon;
            rcb.se_lat = box.se_lat;
            rcb.se_lon = box.se_lon;
            rcb.subframeLatInterval = box.subframeLatInterval;
            rcb.subframeLonInterval = box.subframeLonInterval;
            rcb.chartCode = box.chartCode;
            rcb.startIndexes = new Point(box.startIndexes.x, box.startIndexes.y);
            rcb.endIndexes = new Point(box.endIndexes.x, box.endIndexes.y);
            rcb.tocNumber = box.tocNumber;
            rcb.entryNumber = box.entryNumber;
            rcb.scale = box.scale;
            rcb.percentCoverage = box.percentCoverage;
            rcb.zone = box.zone;
            vector.addElement(rcb);
        }
        return vector;
    }

    public int[] getSubframeData(int tocNumber, int entryNumber, int x, int y) {
        Server serv = this.getServer();
        if (serv == null) {
            return null;
        }
        Debug.message((String)"crfp", (String)"CRFPClient: getting subframe data from server.");
        try {
            byte[] jpegData = serv.getSubframeData((short)tocNumber, (short)entryNumber, (short)x, (short)y, this.jpegQuality, this.clientID);
            if (Debug.debugging((String)"crfpdetail")) {
                Debug.output((String)("CRFPClient: got subframe data length " + jpegData.length));
            }
            if (jpegData.length == 0) {
                return null;
            }
            MemoryCacheImageInputStream iis = new MemoryCacheImageInputStream(new ByteArrayInputStream(jpegData));
            BufferedImage bi = ImageIO.read(iis);
            int height = bi.getHeight();
            int width = bi.getWidth();
            int[] pixels = bi.getRGB(0, 0, width, height, null, 0, width);
            return pixels;
        }
        catch (IOException ioe) {
            Debug.error((String)"CRFPClient: IOException decoding jpeg bytes");
        }
        catch (SystemException e) {
            this.handleCORBAError(e);
        }
        return null;
    }

    public RpfIndexedImageData getRawSubframeData(int tocNumber, int entryNumber, int x, int y) {
        Server serv = this.getServer();
        if (serv == null) {
            return null;
        }
        Debug.message((String)"crfp", (String)"CRFPClient: getting raw subframe data from server.");
        try {
            RawImage ri = serv.getRawSubframeData((short)tocNumber, (short)entryNumber, (short)x, (short)y, this.clientID);
            if (ri.imagedata.length == 0 || ri.colortable.length == 0) {
                return null;
            }
            RpfIndexedImageData riid = new RpfIndexedImageData();
            riid.imageData = ri.imagedata;
            riid.colortable = new OMColor[ri.colortable.length];
            for (int i = 0; i < riid.colortable.length; ++i) {
                riid.colortable[i] = new OMColor(ri.colortable[i]);
            }
            return riid;
        }
        catch (SystemException e) {
            this.handleCORBAError(e);
            return null;
        }
    }

    public String getSubframeAttributes(int tocNumber, int entryNumber, int x, int y) {
        Server serv = this.getServer();
        if (serv == null) {
            return "";
        }
        Debug.message((String)"crfp", (String)"CRFPClient: getting subframe attributes from server.");
        try {
            return serv.getSubframeAttributes((short)tocNumber, (short)entryNumber, (short)x, (short)y, this.clientID);
        }
        catch (SystemException e) {
            this.handleCORBAError(e);
            return "";
        }
    }

    public Server getServer() {
        if (this.server == null) {
            this.initServer();
        }
        return this.server;
    }

    private void initServer() {
        String ior = null;
        Object object = null;
        CORBASupport cs = new CORBASupport();
        try {
            object = cs.readIOR(this.iorURL);
            this.server = ServerHelper.narrow(object);
        }
        catch (IOException ioe) {
            if (Debug.debugging((String)"crfp")) {
                Debug.output((String)("CRFPClient.initServer() IO Exception with ior: " + this.iorURL));
            }
            this.server = null;
            return;
        }
        if (this.server == null && (object = cs.resolveName(this.naming)) != null) {
            this.server = ServerHelper.narrow(object);
            if (Debug.debugging((String)"crfp")) {
                Debug.output((String)"Have a RPF server:");
                Debug.output((String)("*** Server: is a " + this.server.getClass().getName() + "\n" + this.server));
            }
        }
        if (Debug.debugging((String)"crfp")) {
            if (this.server == null) {
                Debug.error((String)("CRFPClient.initServer: null server!\n  IOR=" + ior + "\n  Name = " + this.naming));
            } else {
                Debug.output((String)"CRFPClient: server is golden.");
            }
        }
    }

    protected void handleCORBAError(SystemException e) {
        if (e.toString().indexOf("InterruptedIOException") != -1) {
            Debug.error((String)"CRFPClient server communication interrupted!");
        } else {
            Debug.error((String)("CRFPClient caught CORBA exception: " + (java.lang.Object)((java.lang.Object)e) + "\n" + "CRFPClient Exception class: " + ((java.lang.Object)((java.lang.Object)e)).getClass().getName() + "\n" + e.getMessage()));
            e.printStackTrace();
        }
        this.server = null;
    }
}

