/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf.corba;

import com.bbn.openmap.layer.rpf.RpfFrameProvider;
import com.bbn.openmap.layer.rpf.RpfLayer;
import com.bbn.openmap.layer.rpf.corba.CRFPClient;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.util.PaletteHelper;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CorbaRpfLayer
extends RpfLayer {
    private static final long serialVersionUID = 1L;
    public static final String QuickRedrawProperty = ".quickRedraw";
    protected boolean quickRedraw = false;
    protected Properties props = null;

    public CorbaRpfLayer() {
        this.setFrameProvider(new CRFPClient());
    }

    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        this.props = properties;
        ((CRFPClient)this.frameProvider).setProperties(prefix, properties);
        this.quickRedraw = PropUtils.booleanFromProperties((Properties)properties, (String)(prefix + QuickRedrawProperty), (boolean)false);
    }

    public void removed(Container cont) {
        super.removed(cont);
        this.finalize();
    }

    public void clearCache() {
        if (this.cache != null) {
            this.cache.clearCaches();
        }
        this.frameProvider = null;
        this.setGraphicList(null);
        this.cache = null;
    }

    public void finalize() {
        if (this.frameProvider != null) {
            ((CRFPClient)this.frameProvider).finalize();
        }
    }

    public void setPaths(String[] pathsToRPFDirs) {
        RpfFrameProvider frameProvider = this.getFrameProvider();
        if (frameProvider != null) {
            return;
        }
        this.setFrameProvider(new CRFPClient());
        if (this.props != null) {
            ((CRFPClient)frameProvider).setProperties(this.getPropertyPrefix(), this.props);
        }
        this.cache = null;
    }

    public OMGraphicList prepare() {
        OMGraphicList oldList = this.getGraphicList();
        if (oldList != null) {
            oldList.generate(this.getProjection());
            if (this.getCoverage() != null) {
                this.getCoverage().generate(this.getProjection());
            }
            this.repaint();
        }
        return super.prepare();
    }

    public Component getGUI() {
        Box box = Box.createVerticalBox();
        Box box1 = Box.createVerticalBox();
        Box box2 = Box.createVerticalBox();
        JPanel topbox = new JPanel();
        JCheckBox showMapsCheck = new JCheckBox("Show Images", this.viewAttributes.showMaps);
        showMapsCheck.setActionCommand("mapsCheckCmd");
        showMapsCheck.addActionListener((ActionListener)((Object)this));
        JCheckBox showInfoCheck = new JCheckBox("Show Attributes", this.viewAttributes.showInfo);
        showInfoCheck.setActionCommand("infoCheckCmd");
        showInfoCheck.addActionListener((ActionListener)((Object)this));
        boolean locked = !this.viewAttributes.chartSeries.equalsIgnoreCase("ANY");
        String lockedTitle = locked ? "Displaying Only - " + this.viewAttributes.chartSeries : "Limit Chart Selection";
        JCheckBox lockSeriesCheck = new JCheckBox(lockedTitle, locked);
        lockSeriesCheck.setActionCommand("lockSeriesCmd");
        lockSeriesCheck.addActionListener((ActionListener)((Object)this));
        box1.add(showMapsCheck);
        box1.add(showInfoCheck);
        box1.add(lockSeriesCheck);
        if (this.coverage != null) {
            JCheckBox showCoverageCheck = new JCheckBox("Show Coverage Tool", false);
            showCoverageCheck.setActionCommand("coverageCheckCmd");
            showCoverageCheck.addActionListener((ActionListener)((Object)this));
            box1.add(showCoverageCheck);
        }
        topbox.add(box1);
        topbox.add(box2);
        box.add(topbox);
        JPanel opaquePanel = PaletteHelper.createPaletteJPanel((String)"Map Opaqueness");
        JSlider opaqueSlide = new JSlider(0, 0, 255, this.viewAttributes.opaqueness);
        Hashtable<Integer, JLabel> dict = new Hashtable<Integer, JLabel>();
        dict.put(new Integer(0), new JLabel("clear"));
        dict.put(new Integer(255), new JLabel("opaque"));
        opaqueSlide.setLabelTable(dict);
        opaqueSlide.setPaintLabels(true);
        opaqueSlide.setMajorTickSpacing(50);
        opaqueSlide.setPaintTicks(true);
        opaqueSlide.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ce) {
                JSlider slider = (JSlider)ce.getSource();
                if (!slider.getValueIsAdjusting()) {
                    CorbaRpfLayer.this.getViewAttributes().opaqueness = slider.getValue();
                    CorbaRpfLayer.this.getFrameProvider().setViewAttributes(CorbaRpfLayer.this.getViewAttributes());
                    CorbaRpfLayer.this.fireRequestInfoLine("RPF Opaqueness set to " + CorbaRpfLayer.this.getViewAttributes().opaqueness + " for future requests.");
                }
            }
        });
        opaquePanel.add(opaqueSlide);
        box.add(opaquePanel);
        if (this.getViewAttributes().colorModel == 0) {
            JPanel qualityPanel = PaletteHelper.createPaletteJPanel((String)"Image JPEG Quality/Time");
            JSlider qualitySlide = new JSlider(0, 0, 100, (int)(((CRFPClient)this.frameProvider).jpegQuality * 100.0f));
            Hashtable<Integer, JLabel> dict2 = new Hashtable<Integer, JLabel>();
            dict2.put(new Integer(0), new JLabel("Less"));
            dict2.put(new Integer(100), new JLabel("More"));
            qualitySlide.setLabelTable(dict2);
            qualitySlide.setPaintLabels(true);
            qualitySlide.setMajorTickSpacing(20);
            qualitySlide.setPaintTicks(true);
            qualitySlide.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent ce) {
                    JSlider slider = (JSlider)ce.getSource();
                    if (!slider.getValueIsAdjusting()) {
                        ((CRFPClient)CorbaRpfLayer.this.getFrameProvider()).jpegQuality = (float)slider.getValue() / 100.0f;
                        CorbaRpfLayer.this.fireRequestInfoLine("RPF Image JPEG Quality set to " + ((CRFPClient)CorbaRpfLayer.this.getFrameProvider()).jpegQuality + " for future requests.");
                    }
                }
            });
            qualityPanel.add(qualitySlide);
            box.add(qualityPanel);
        }
        JPanel subbox2 = new JPanel();
        JButton redraw = new JButton("Redraw RPF Layer");
        redraw.addActionListener((ActionListener)((Object)this));
        subbox2.add(redraw);
        box.add(subbox2);
        return box;
    }
}

