/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.specialist;

import com.bbn.openmap.Environment;
import com.bbn.openmap.corba.CSpecialist.ActionUnion;
import com.bbn.openmap.corba.CSpecialist.CProjection;
import com.bbn.openmap.corba.CSpecialist.GraphicChange;
import com.bbn.openmap.corba.CSpecialist.LLPoint;
import com.bbn.openmap.corba.CSpecialist.Server;
import com.bbn.openmap.corba.CSpecialist.ServerHelper;
import com.bbn.openmap.corba.CSpecialist.UGraphic;
import com.bbn.openmap.corba.CSpecialist.UWidget;
import com.bbn.openmap.corba.CSpecialist.UpdateGraphic;
import com.bbn.openmap.corba.CSpecialist.UpdateRecord;
import com.bbn.openmap.event.InfoDisplayEvent;
import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.ListResetPCPolicy;
import com.bbn.openmap.layer.policy.ProjectionChangePolicy;
import com.bbn.openmap.layer.specialist.CSpecPalette;
import com.bbn.openmap.layer.specialist.J2525;
import com.bbn.openmap.layer.specialist.JBitmap;
import com.bbn.openmap.layer.specialist.JCircle;
import com.bbn.openmap.layer.specialist.JGraphic;
import com.bbn.openmap.layer.specialist.JGraphicChange;
import com.bbn.openmap.layer.specialist.JGraphicList;
import com.bbn.openmap.layer.specialist.JLine;
import com.bbn.openmap.layer.specialist.JObjectHolder;
import com.bbn.openmap.layer.specialist.JPoly;
import com.bbn.openmap.layer.specialist.JRaster;
import com.bbn.openmap.layer.specialist.JRect;
import com.bbn.openmap.layer.specialist.JText;
import com.bbn.openmap.layer.specialist.JUnit;
import com.bbn.openmap.layer.specialist.MakeProjection;
import com.bbn.openmap.layer.specialist.MapGesture;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import com.bbn.openmap.util.corba.CORBASupport;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.Object;
import org.omg.CORBA.ShortHolder;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.SystemException;

public class CSpecLayer
extends OMGraphicHandlerLayer
implements MapMouseListener {
    public static final String iorUrlProperty = "ior";
    public static final String namingProperty = "name";
    public static final String staticArgsProperty = "staticArgs";
    public static final String serverUpdateProperty = "allowServerUpdates";
    protected URL iorURL = null;
    protected String naming = null;
    protected String staticArgs = null;
    protected String dynamicArgs = null;
    protected String clientID = Environment.generateUniqueString();
    protected UWidget[] widgets = null;
    protected transient CSpecPalette gui = null;
    protected transient Server specialist = null;
    protected ShortHolder selectDist = new ShortHolder();
    protected BooleanHolder wantAreaEvents = new BooleanHolder();
    protected GraphicChange notifyOnChange = null;
    protected MapGesture mapGesture = new MapGesture();
    protected boolean acceptingEvents = false;
    protected boolean sentInfoLine = false;
    protected int dirtybits = 0;
    public static final transient int PALETTE_DIRTY = 1;
    public static final transient int PREMATURE_FINISH = 4;
    public static final transient int EXCEPTION = 8;
    public static final transient int DIRTYMASK = -1;
    protected boolean showDialogs = Environment.getBoolean((String)"com.bbn.openmap.ShowLayerMessages");

    public CSpecLayer() {
        this.handleGraphicChangeRequests(false);
        this.setProjectionChangePolicy((ProjectionChangePolicy)new ListResetPCPolicy((OMGraphicHandlerLayer)this));
    }

    public void handleGraphicChangeRequests(boolean setting) {
        if (setting) {
            if (this.notifyOnChange == null) {
                this.notifyOnChange = new JGraphicChange(this);
            }
        } else {
            this.notifyOnChange = null;
        }
    }

    public void finalize() {
        if (Debug.debugging((String)"cspec")) {
            Debug.output((String)(this.getName() + "|CSpecLayer.finalize(): calling shutdown"));
        }
        try {
            if (this.specialist != null) {
                this.specialist.signoff(this.clientID);
            }
            this.specialist = null;
        }
        catch (SystemException e) {
            System.err.println(this.getName() + "|CSpecLayer.finalize(): " + (java.lang.Object)((java.lang.Object)e));
        }
        catch (Throwable t) {
            System.err.println(this.getName() + "|CSpecLayer.finalize(): " + t);
        }
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix((String)prefix);
        String url = props.getProperty(prefix + iorUrlProperty);
        if (url != null) {
            try {
                this.setIorUrl(PropUtils.getResourceOrFileOrURL(null, (String)url));
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("\"" + url + "\" is malformed.");
            }
        }
        this.naming = props.getProperty(prefix + namingProperty);
        String staticArgValue = props.getProperty(prefix + staticArgsProperty);
        this.setStaticArgs(staticArgValue);
        this.handleGraphicChangeRequests(PropUtils.booleanFromProperties((Properties)props, (String)(prefix + serverUpdateProperty), (this.notifyOnChange != null ? 1 : 0) != 0));
    }

    public void setArgs(String[] argv) {
        int argc = argv.length;
        if (argc == 0) {
            return;
        }
        String url = argv[0];
        StringBuffer argBuf = new StringBuffer();
        if (argc > 1) {
            argBuf.append(argv[1]);
            for (int i = 2; i < argc; ++i) {
                argBuf.append(" ").append(argv[i]);
            }
        }
        try {
            this.setIorUrl(new URL(url));
            if (Debug.debugging((String)"cspec")) {
                Debug.output((String)(this.getName() + "(CSpecLayer) using ior from " + url));
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("\"" + url + "\"" + " is not a well formed URL");
        }
        this.setStaticArgs(argBuf.toString());
    }

    public Server getSpecialist() {
        if (this.specialist == null) {
            this.initSpecialist();
        }
        return this.specialist;
    }

    private void initSpecialist() {
        String ior = null;
        Object object = null;
        CORBASupport cs = new CORBASupport();
        try {
            object = cs.readIOR(this.iorURL);
            this.specialist = ServerHelper.narrow(object);
        }
        catch (IOException ioe) {
            if (Debug.debugging((String)"cspec")) {
                Debug.output((String)(this.getName() + "(CSpecLayer).initSpecialist() IO Exception with ior: " + this.iorURL));
            }
            this.specialist = null;
            return;
        }
        if (this.specialist == null && (object = cs.resolveName(this.naming)) != null) {
            this.specialist = ServerHelper.narrow(object);
            if (Debug.debugging((String)"cspec")) {
                Debug.output((String)"Have a specialist:");
                Debug.output((String)("*** Specialist Server: is a " + this.specialist.getClass().getName() + "\n" + this.specialist));
            }
        }
        if (this.specialist == null && Debug.debugging((String)"cspec")) {
            System.err.println("CSpecLayer.initSpecialist: null specialist!\n  IOR=" + ior + "\n  Name = " + this.naming);
        }
    }

    public void setSpecialist(Server aSpecialist) {
        this.specialist = aSpecialist;
        if (this.specialist == null) {
            this.widgets = null;
            this.gui = null;
            this.setList(null);
        }
    }

    public String getArgs() {
        return this.dynamicArgs;
    }

    public void setArgs(String args) {
        this.dynamicArgs = args;
    }

    public String getStaticArgs() {
        return this.staticArgs;
    }

    public void setStaticArgs(String args) {
        this.staticArgs = args;
    }

    public URL getIorUrl() {
        return this.iorURL;
    }

    public void setIorUrl(URL url) {
        this.iorURL = url;
    }

    protected UGraphic[] getSpecGraphics(Projection p) {
        UGraphic[] graphics;
        block14: {
            graphics = null;
            Server spec = this.getSpecialist();
            if (Debug.debugging((String)"cspec")) {
                Debug.output((String)(this.getName() + "|CSpecLayer.getSpecGraphics()"));
            }
            Point2D center = p.getCenter();
            CProjection cproj = new CProjection(MakeProjection.getProjectionType(p), new LLPoint((float)center.getY(), (float)center.getX()), (short)p.getHeight(), (short)p.getWidth(), (int)p.getScale());
            Point2D ul = p.getUpperLeft();
            Point2D lr = p.getLowerRight();
            LLPoint ll1 = new LLPoint((float)ul.getY(), (float)ul.getX());
            LLPoint ll2 = new LLPoint((float)lr.getY(), (float)lr.getX());
            if (this.isCancelled()) {
                this.dirtybits |= 4;
                if (Debug.debugging((String)"cspec")) {
                    Debug.output((String)(this.getName() + "|CSpecLayer.getSpecGraphics(): aborted."));
                }
                return null;
            }
            if (spec == null) {
                if (Debug.debugging((String)"cspec")) {
                    System.err.println(this.getName() + "|CSpecLayer.getSpecGraphics(): null specialist!");
                }
                return null;
            }
            try {
                this.mapGesture.setProjection(p);
                String staticArguments = this.getStaticArgs();
                if (staticArguments == null) {
                    staticArguments = "";
                    this.setStaticArgs(staticArguments);
                }
                StringHolder dynamicArgsHolder = new StringHolder(this.getArgs());
                if (dynamicArgsHolder.value == null) {
                    dynamicArgsHolder.value = "";
                }
                if (Debug.debugging((String)"cspec")) {
                    Debug.output((String)(this.getName() + "|CSpecLayer.getSpecGraphics():" + " calling getRectangle with projection: " + p + " ul=" + ul + " lr=" + lr + " staticArgs=\"" + staticArguments + "\"" + " dynamicArgs=\"" + dynamicArgsHolder.value + "\"" + " notifyOnChange=\"" + this.notifyOnChange + "\"" + " clientID=" + this.clientID));
                }
                long start = System.currentTimeMillis();
                if (Debug.debugging((String)"cspecdetail")) {
                    Debug.output((String)("*** Specialist Server: is a " + spec.getClass().getName() + "\n" + spec));
                }
                graphics = spec.getRectangle(cproj, ll1, ll2, staticArguments, dynamicArgsHolder, this.selectDist, this.wantAreaEvents, this.notifyOnChange, this.clientID);
                long stop = System.currentTimeMillis();
                if (Debug.debugging((String)"cspec")) {
                    Debug.output((String)(this.getName() + "|CSpecLayer.getSpecGraphics(): got " + graphics.length + " graphics in " + (double)(stop - start) / 1000.0 + " seconds."));
                }
            }
            catch (SystemException e) {
                this.dirtybits |= 8;
                if (e.toString().indexOf("InterruptedIOException") != -1) {
                    System.err.println(this.getName() + "|CSpecLayer.getSpecGraphics(): " + "getRectangle() call interrupted!");
                } else {
                    System.err.println(this.getName() + "|CSpecLayer.getSpecGraphics(): " + "Caught CORBA exception: " + (java.lang.Object)((java.lang.Object)e));
                    System.err.println(this.getName() + "|CSpecLayer.getSpecGraphics(): " + "Exception class: " + ((java.lang.Object)((java.lang.Object)e)).getClass().getName());
                    e.printStackTrace();
                }
                this.setSpecialist(null);
                if (!this.showDialogs) break block14;
                this.postCORBAErrorMsg("CORBA Exception while getting graphics from\n" + this.getName() + " specialist:\n" + ((java.lang.Object)((java.lang.Object)e)).getClass().getName());
            }
        }
        return graphics;
    }

    public synchronized OMGraphicList prepare() {
        JGraphicList emptyList = new JGraphicList();
        if (this.isCancelled()) {
            this.dirtybits |= 4;
            if (Debug.debugging((String)"basic")) {
                Debug.output((String)(this.getName() + "|CSpecLayer.prepare(): aborted."));
            }
            return emptyList;
        }
        if (Debug.debugging((String)"basic")) {
            Debug.output((String)(this.getName() + "|CSpecLayer.prepare(): doing it"));
        }
        this.dirtybits = 0;
        this.setAcceptingEvents(false);
        Projection projection = this.getProjection();
        UGraphic[] specGraphics = this.getSpecGraphics(projection);
        if (this.isCancelled()) {
            this.dirtybits |= 4;
            if (Debug.debugging((String)"basic")) {
                Debug.output((String)(this.getName() + "|CSpecLayer.prepare(): " + "aborted during/after getRectangle()."));
            }
            return emptyList;
        }
        if (specGraphics == null) {
            return emptyList;
        }
        long start = System.currentTimeMillis();
        JGraphicList graphics = CSpecLayer.createGraphicsList(specGraphics, projection);
        long stop = System.currentTimeMillis();
        if (Debug.debugging((String)"cspec")) {
            Debug.output((String)(this.getName() + "|CSpecLayer.prepare(): generated " + specGraphics.length + " graphics in " + (double)(stop - start) / 1000.0 + " seconds."));
        }
        if (this.isCancelled()) {
            this.dirtybits |= 4;
            if (Debug.debugging((String)"basic")) {
                Debug.output((String)(this.getName() + "|CSpecLayer.prepare(): " + "aborted while generating graphics."));
            }
            return emptyList;
        }
        if (Debug.debugging((String)"basic")) {
            Debug.output((String)(this.getName() + "|CSpecLayer.prepare(): finished preparing " + graphics.size() + " graphics"));
        }
        this.setAcceptingEvents(true);
        return graphics;
    }

    public static JGraphicList createGraphicsList(UGraphic[] uGraphics, Projection proj) {
        int nGraphics = uGraphics.length;
        JGraphicList graphics = new JGraphicList(nGraphics);
        graphics.setTraverseMode(0);
        block11: for (int i = 0; i < nGraphics; ++i) {
            switch (uGraphics[i].discriminator().value()) {
                case 3: {
                    JPoly jpoly = new JPoly(uGraphics[i].epoly());
                    jpoly.generate(proj);
                    graphics.add((OMGraphic)jpoly);
                    continue block11;
                }
                case 9: {
                    JRaster jraster = new JRaster(uGraphics[i].eras());
                    jraster.generate(proj);
                    graphics.add((OMGraphic)jraster);
                    continue block11;
                }
                case 1: {
                    JBitmap jbitmap = new JBitmap(uGraphics[i].ebit());
                    jbitmap.generate(proj);
                    graphics.add((OMGraphic)jbitmap);
                    continue block11;
                }
                case 2: {
                    JText jtext = new JText(uGraphics[i].etext());
                    jtext.generate(proj);
                    graphics.add((OMGraphic)jtext);
                    continue block11;
                }
                case 4: {
                    JLine jline = new JLine(uGraphics[i].eline());
                    jline.generate(proj);
                    graphics.add((OMGraphic)jline);
                    continue block11;
                }
                case 5: {
                    JUnit junit = new JUnit(uGraphics[i].eunit());
                    junit.generate(proj);
                    graphics.add((OMGraphic)junit);
                    continue block11;
                }
                case 6: {
                    J2525 j2525 = new J2525(uGraphics[i].e2525());
                    j2525.generate(proj);
                    graphics.add((OMGraphic)j2525);
                    continue block11;
                }
                case 7: {
                    JRect jrect = new JRect(uGraphics[i].erect());
                    jrect.generate(proj);
                    graphics.add((OMGraphic)jrect);
                    continue block11;
                }
                case 8: {
                    JCircle jcircle = new JCircle(uGraphics[i].ecirc());
                    jcircle.generate(proj);
                    graphics.add((OMGraphic)jcircle);
                    continue block11;
                }
                default: {
                    System.err.println("JGraphic.generateGraphics: ignoring invalid type");
                }
            }
        }
        return graphics;
    }

    public Component getGUI() {
        block12: {
            if (this.specialist == null) {
                this.initSpecialist();
            }
            if (this.specialist == null) {
                if (Debug.debugging((String)"cspec")) {
                    Debug.output((String)(this.getName() + "|CSpecLayer.getGUI(): initSpecialist() unsuccessful!"));
                }
                return null;
            }
            try {
                block13: {
                    String staticArguments;
                    if (this.widgets != null) break block12;
                    StringHolder paletteDynamicArgs = new StringHolder(this.getArgs());
                    if (paletteDynamicArgs.value == null) {
                        paletteDynamicArgs.value = "";
                    }
                    if ((staticArguments = this.getStaticArgs()) == null) {
                        staticArguments = "";
                        this.setStaticArgs(staticArguments);
                    }
                    if (Debug.debugging((String)"cspec")) {
                        Debug.output((String)(this.getName() + "|CSpecLayer.getGUI(): calling getPaletteConfig(" + staticArguments + "," + paletteDynamicArgs.value + "," + this.clientID + ")"));
                    }
                    try {
                        this.widgets = this.specialist.getPaletteConfig(null, staticArguments, paletteDynamicArgs, this.clientID);
                    }
                    catch (SystemException e) {
                        System.err.println(this.getName() + "|CSpecLayer.getGUI(): " + (java.lang.Object)((java.lang.Object)e));
                        e.printStackTrace();
                        this.setSpecialist(null);
                        if (!this.showDialogs) break block13;
                        this.postCORBAErrorMsg("CORBA Exception while getting palette from\n" + this.getName() + " specialist:\n" + ((java.lang.Object)((java.lang.Object)e)).getClass().getName());
                    }
                }
                this.gui = this.widgets == null || this.widgets.length == 0 ? null : new CSpecPalette(this.widgets, this.clientID, this);
            }
            catch (OutOfMemoryError e) {
                this.setSpecialist(null);
                System.err.println(this.getName() + "|CSpecLayer.getGUI(): " + e);
                if (this.showDialogs) {
                    this.postMemoryErrorMsg("OutOfMemory while getting palette from\n" + this.getName() + " specialist.");
                }
            }
            catch (Throwable t) {
                this.setSpecialist(null);
                System.err.println(this.getName() + "|CSpecLayer.getGUI(): " + t);
                t.printStackTrace();
                if (!this.showDialogs) break block12;
                this.postException("Exception while getting palette from\n" + this.getName() + " specialist:\n" + t.getClass().getName());
            }
        }
        return this.gui;
    }

    protected void setPaletteIsDirty(boolean paletteIsDirty) {
        if (paletteIsDirty) {
            this.dirtybits |= 1;
        }
    }

    protected void forgetPalette() {
        this.widgets = null;
        this.gui = null;
    }

    public void setAcceptingEvents(boolean listening) {
        this.acceptingEvents = listening;
    }

    public boolean isAcceptingEvents() {
        return this.acceptingEvents;
    }

    public MapMouseListener getMapMouseListener() {
        return this;
    }

    public String[] getMouseModeServiceList() {
        String[] ret = new String[]{"Gestures"};
        return ret;
    }

    public boolean mousePressed(MouseEvent e) {
        if (this.acceptingEvents && this.specialist != null) {
            return this.handleGesture(e, 0, true);
        }
        return false;
    }

    public boolean mouseReleased(MouseEvent e) {
        if (this.acceptingEvents && this.specialist != null) {
            return this.handleGesture(e, 0, false);
        }
        return false;
    }

    public boolean mouseClicked(MouseEvent e) {
        if (this.acceptingEvents && this.specialist != null) {
            return this.handleGesture(e, 0, false);
        }
        return false;
    }

    public void mouseEntered(MouseEvent e) {
        if (this.acceptingEvents && this.specialist != null) {
            this.handleGesture(e, 1, false);
        }
    }

    public void mouseExited(MouseEvent e) {
        if (this.acceptingEvents && this.specialist != null) {
            this.handleGesture(e, 1, false);
        }
    }

    public boolean mouseDragged(MouseEvent e) {
        if (this.acceptingEvents && this.specialist != null) {
            return this.handleGesture(e, 1, true);
        }
        return false;
    }

    public boolean mouseMoved(MouseEvent e) {
        if (this.acceptingEvents && this.specialist != null) {
            return this.handleGesture(e, 1, false);
        }
        return false;
    }

    public void mouseMoved() {
        if (this.acceptingEvents && this.specialist != null) {
            this.handleGesture(null, 1, false);
        }
    }

    public boolean handleGesture(MouseEvent evt, int eventType, boolean MouseDown) {
        boolean got_info = false;
        boolean got_the_stuff = false;
        boolean updated_graphics = false;
        OMGraphic moused = null;
        JGraphicList jjGraphics = (JGraphicList)this.getList();
        if (this.sentInfoLine) {
            this.fireRequestInfoLine("");
            this.sentInfoLine = false;
        }
        if (!this.isAcceptingEvents() || jjGraphics == null) {
            return false;
        }
        if (evt == null) {
            if (Debug.debugging((String)"cspec")) {
                Debug.output((String)(this.getName() + "|CSpecLayer.handleGesture(): null evt!"));
            }
            return false;
        }
        try {
            this.mapGesture.setMouseEvent(evt, eventType, MouseDown);
            moused = (OMGraphic)jjGraphics.findClosest(evt.getX(), evt.getY(), this.selectDist.value);
            ActionUnion[] action = null;
            switch (this.mapGesture.getMode()) {
                case 1: {
                    if (moused != null && ((JObjectHolder)moused).getObject().comp != null) {
                        action = ((JObjectHolder)moused).getObject().comp.sendGesture(JGraphic.constructGesture(this.mapGesture), this.clientID);
                    } else if (this.specialist != null) {
                        ActionUnion[] actionUnionArray = action = this.wantAreaEvents.value ? this.specialist.sendGesture(JGraphic.constructGesture(this.mapGesture), this.clientID) : null;
                        if (action == null) {
                            if (Debug.debugging((String)"cspec")) {
                                Debug.output((String)(this.getName() + "|CSpecLayer.handleGesture(): null action!"));
                            }
                            return false;
                        }
                        if (action.length == 0) {
                            return false;
                        }
                    }
                    if (action != null) break;
                    if (Debug.debugging((String)"cspec")) {
                        System.err.println(this.getName() + "|CSpecLayer.handleGesture(): null action!");
                    }
                    return false;
                }
                default: {
                    System.err.println("CSpecLayer|" + this.getName() + "|handleGesture() - cooked modes not supported");
                }
            }
            this.mapGesture.actionType = new int[action.length];
            block15: for (int i = 0; i < action.length; ++i) {
                switch (action[i].discriminator().value()) {
                    case -1: {
                        continue block15;
                    }
                    case 0: {
                        updated_graphics = true;
                        this.updateGraphics(action[i].ginfo());
                        continue block15;
                    }
                    case 2: {
                        if (got_info) continue block15;
                        if (Debug.debugging((String)"cspec")) {
                            Debug.output((String)("CSpecLayer|" + this.getName() + "|handleGesture(): Requesting Info Text " + action[i].itext()));
                        }
                        this.fireRequestInfoLine(action[i].itext());
                        this.sentInfoLine = true;
                        got_info = true;
                        continue block15;
                    }
                    case 3: {
                        if (got_the_stuff) continue block15;
                        if (Debug.debugging((String)"cspec")) {
                            Debug.output((String)("CSpecLayer|" + this.getName() + "|handleGesture(): Requesting Plain Text " + action[i].ptext()));
                        }
                        this.fireRequestBrowserContent(action[i].ptext());
                        got_the_stuff = true;
                        continue block15;
                    }
                    case 4: {
                        if (got_the_stuff) continue block15;
                        if (Debug.debugging((String)"cspec")) {
                            Debug.output((String)("CSpecLayer|" + this.getName() + "|handleGesture(): Requesting HTML Text " + action[i].htext()));
                        }
                        this.fireRequestBrowserContent(action[i].htext());
                        got_the_stuff = true;
                        continue block15;
                    }
                    case 5: {
                        if (got_the_stuff) continue block15;
                        if (Debug.debugging((String)"cspec")) {
                            Debug.output((String)("CSpecLayer|" + this.getName() + "|handleGesture(): Requesting URL " + action[i].url()));
                        }
                        this.fireRequestURL(action[i].url());
                        got_the_stuff = true;
                        continue block15;
                    }
                    default: {
                        System.err.println("CSpecLayer|" + this.getName() + "|handleGesture(): invalid ActionSeq");
                    }
                }
            }
        }
        catch (SystemException e) {
            System.err.println(this.getName() + "|CSpecLayer.handleGesture(): " + (java.lang.Object)((java.lang.Object)e));
            if (this.showDialogs) {
                this.postCORBAErrorMsg("CORBA Exception while gesturing on\n" + this.getName() + " specialist:\n" + ((java.lang.Object)((java.lang.Object)e)).getClass().getName());
            }
            return false;
        }
        catch (OutOfMemoryError e) {
            this.setSpecialist(null);
            if (this.showDialogs) {
                this.postMemoryErrorMsg("OutOfMemory while gesturing on\n" + this.getName() + " specialist.");
            }
            return false;
        }
        catch (Throwable t) {
            if (this.showDialogs) {
                this.postException("Exception while gesturing on\n" + this.getName() + " specialist:\n" + t.getClass().getName());
            }
            t.printStackTrace();
            return false;
        }
        if (updated_graphics) {
            this.repaint();
        }
        return true;
    }

    protected void updateGraphics(UpdateRecord[] updateRec) {
        JGraphicList jGraphics = (JGraphicList)this.getList();
        Projection projection = this.getProjection();
        UpdateGraphic upgraphic = null;
        for (int i = 0; i < updateRec.length; ++i) {
            String gID = updateRec[i].gID;
            block13: for (int j = 0; j < updateRec[i].objectUpdates.length; ++j) {
                upgraphic = updateRec[i].objectUpdates[j];
                switch (upgraphic.discriminator().value()) {
                    case 0: {
                        JObjectHolder graphic = (JObjectHolder)jGraphics.getOMGraphicWithId(gID);
                        if (graphic == null) continue block13;
                        graphic.update(upgraphic.gf_update());
                        ((OMGraphic)graphic).regenerate(projection);
                        continue block13;
                    }
                    case 1: {
                        JBitmap bitmap = (JBitmap)jGraphics.getOMGraphicWithId(gID);
                        if (bitmap == null) continue block13;
                        bitmap.update(upgraphic.bf_update());
                        bitmap.regenerate(projection);
                        continue block13;
                    }
                    case 2: {
                        JText text = (JText)jGraphics.getOMGraphicWithId(gID);
                        if (text == null) continue block13;
                        text.update(upgraphic.tf_update());
                        text.regenerate(projection);
                        continue block13;
                    }
                    case 3: {
                        JPoly poly = (JPoly)jGraphics.getOMGraphicWithId(gID);
                        if (poly == null) continue block13;
                        poly.update(upgraphic.pf_update());
                        poly.regenerate(projection);
                        continue block13;
                    }
                    case 4: {
                        JLine line = (JLine)jGraphics.getOMGraphicWithId(gID);
                        if (line == null) continue block13;
                        line.update(upgraphic.lf_update());
                        line.regenerate(projection);
                        continue block13;
                    }
                    case 7: {
                        JRect rect = (JRect)jGraphics.getOMGraphicWithId(gID);
                        if (rect == null) continue block13;
                        rect.update(upgraphic.rf_update());
                        rect.regenerate(projection);
                        continue block13;
                    }
                    case 9: {
                        JRaster raster = (JRaster)jGraphics.getOMGraphicWithId(gID);
                        if (raster == null) continue block13;
                        raster.update(upgraphic.rasf_update());
                        raster.regenerate(projection);
                        continue block13;
                    }
                    case 8: {
                        JCircle circ = (JCircle)jGraphics.getOMGraphicWithId(gID);
                        if (circ == null) continue block13;
                        circ.update(upgraphic.cf_update());
                        circ.regenerate(projection);
                        continue block13;
                    }
                    case 5: {
                        JUnit unitsymbol = (JUnit)jGraphics.getOMGraphicWithId(gID);
                        if (unitsymbol == null) continue block13;
                        unitsymbol.update(upgraphic.usf_update());
                        unitsymbol.regenerate(projection);
                        continue block13;
                    }
                    case 6: 
                    case 10: 
                    case 11: 
                    case 12: {
                        System.err.println("CSpecLayer|" + this.getName() + "|updateGraphics: Graphics Update Type not implemented.");
                        continue block13;
                    }
                    default: {
                        System.err.println("CSpecLayer|" + this.getName() + "|updateGraphics: ignoring weird update");
                    }
                }
            }
        }
    }

    public boolean getShowDialogs() {
        return this.showDialogs;
    }

    public void setShowDialogs(boolean show) {
        this.showDialogs = show;
    }

    protected void postMemoryErrorMsg(String msg) {
        this.fireRequestMessage(new InfoDisplayEvent((java.lang.Object)this, msg));
    }

    protected void postCORBAErrorMsg(String msg) {
        this.fireRequestMessage(new InfoDisplayEvent((java.lang.Object)this, msg));
    }

    protected void postException(String msg) {
        this.fireRequestMessage(new InfoDisplayEvent((java.lang.Object)this, msg));
    }

    public void removed(Container cont) {
        if (Debug.debugging((String)"cspec")) {
            Debug.output((String)(this.getName() + "CSpecLayer.removed(): Nullifying graphics"));
        }
        if (this.specialist != null) {
            this.specialist.signoff(this.clientID);
        }
        this.setSpecialist(null);
    }
}

