/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.specialist;

import com.bbn.openmap.corba.CSpecialist.CColorPackage.EColor;
import com.bbn.openmap.corba.CSpecialist.GraphicPackage.EGraphic;
import com.bbn.openmap.corba.CSpecialist.GraphicPackage.GF_update;
import com.bbn.openmap.corba.CSpecialist.Keypress;
import com.bbn.openmap.corba.CSpecialist.LLPoint;
import com.bbn.openmap.corba.CSpecialist.Mouse;
import com.bbn.openmap.corba.CSpecialist.MouseEvent;
import com.bbn.openmap.corba.CSpecialist.XYPoint;
import com.bbn.openmap.corba.CSpecialist.key_modifiers;
import com.bbn.openmap.layer.specialist.JObjectHolder;
import com.bbn.openmap.layer.specialist.MapGesture;
import com.bbn.openmap.omGraphics.OMGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.Serializable;

public class JGraphic
implements Serializable {
    public static final int GRAPHICTYPE_UNITSYMBOL = 8;
    public static final int GRAPHICTYPE_2525SYMBOL = 9;
    public static final int GRAPHICTYPE_FORCEARROW = 10;
    public static final int GRAPHICTYPE_NEW = 11;
    public static final int GRAPHICTYPE_REORDER = 12;

    private JGraphic() {
    }

    public static void fillOMGraphicParams(OMGraphic newbie, EGraphic egraphic) {
        newbie.setLineType(JGraphic.getOMGraphicLineType(egraphic.lType.value()));
        newbie.setRenderType(JGraphic.getOMGraphicRenderType(egraphic.rType.value()));
        newbie.setStroke((Stroke)new BasicStroke(egraphic.lineWidth));
        newbie.setDeclutterType(egraphic.dcType.value());
        newbie.setLinePaint((Paint)JGraphic.getColor(egraphic.color));
        newbie.setFillPaint((Paint)JGraphic.getColor(egraphic.fillColor));
        if (newbie instanceof JObjectHolder) {
            ((JObjectHolder)newbie).setObject(egraphic.obj);
        }
    }

    public static int getOMGraphicRenderType(int cRenderType) {
        int rType;
        switch (cRenderType) {
            case 1: {
                rType = 1;
                break;
            }
            case 3: {
                rType = 3;
                break;
            }
            default: {
                rType = 2;
            }
        }
        return rType;
    }

    public static int getOMGraphicLineType(int cLineType) {
        int lType;
        switch (cLineType) {
            case 2: {
                lType = 2;
                break;
            }
            case 3: {
                lType = 3;
                break;
            }
            default: {
                lType = 1;
            }
        }
        return lType;
    }

    public static int getOMGraphicDeclutterType(int cDeclutterType) {
        int dcType;
        switch (cDeclutterType) {
            case 1: {
                dcType = 1;
                break;
            }
            case 2: {
                dcType = 2;
                break;
            }
            case 3: {
                dcType = 3;
                break;
            }
            default: {
                dcType = 0;
            }
        }
        return dcType;
    }

    public static int getOMGraphicType(int cGraphicType) {
        int gtype;
        switch (cGraphicType) {
            case 1: {
                gtype = 1;
                break;
            }
            case 2: {
                gtype = 2;
                break;
            }
            case 3: {
                gtype = 3;
                break;
            }
            case 4: {
                gtype = 4;
                break;
            }
            case 5: {
                gtype = 8;
                break;
            }
            case 6: {
                gtype = 9;
                break;
            }
            case 7: {
                gtype = 5;
                break;
            }
            case 8: {
                gtype = 6;
                break;
            }
            case 9: {
                gtype = 7;
                break;
            }
            case 10: {
                gtype = 10;
                break;
            }
            case 11: {
                gtype = 11;
                break;
            }
            case 12: {
                gtype = 12;
                break;
            }
            default: {
                gtype = 0;
            }
        }
        return gtype;
    }

    public static Color getColor(EColor color) {
        Color ret = color != null ? (color.red == 0 && color.green == 0 && color.blue == 0 && color.color == null ? null : new Color(color.red >> 8 & 0xFF, color.green >> 8 & 0xFF, color.blue >> 8 & 0xFF)) : null;
        return ret;
    }

    protected static MouseEvent constructGesture(MapGesture gest) {
        Mouse mouse = new Mouse();
        mouse.point = new XYPoint((short)gest.point.x, (short)gest.point.y);
        mouse.llpoint = new LLPoint(gest.llpoint.getLatitude(), gest.llpoint.getLongitude());
        mouse.press = gest.press;
        mouse.mousebutton = gest.mousebutton;
        mouse.modifiers = new key_modifiers(gest.alt, gest.shift, gest.control);
        MouseEvent event = new MouseEvent();
        switch (gest.event_type) {
            case 0: {
                event.click(mouse);
                break;
            }
            case 1: {
                event.motion(mouse);
                break;
            }
            case 2: {
                event.keypress(new Keypress(mouse.point, gest.key, mouse.modifiers));
                break;
            }
            default: {
                System.err.println("JGraphic.constructGesture() - invalid type");
            }
        }
        return event;
    }

    public static void update(JObjectHolder graphic, GF_update update) {
        switch (update.discriminator().value()) {
            case 0: {
                graphic.setObject(update.obj());
                break;
            }
            case 1: {
                ((OMGraphic)graphic).setLineType(update.lType().value());
                break;
            }
            case 2: {
                ((OMGraphic)graphic).setRenderType(update.rType().value());
                break;
            }
            case 3: {
                ((OMGraphic)graphic).setLinePaint((Paint)JGraphic.getColor(update.color()));
                break;
            }
            case 4: {
                ((OMGraphic)graphic).setFillPaint((Paint)JGraphic.getColor(update.fillColor()));
                break;
            }
            case 5: {
                ((OMGraphic)graphic).setStroke((Stroke)new BasicStroke(update.lineWidth()));
                break;
            }
            case 6: {
                System.err.println("ignoring stipple");
                break;
            }
            case 7: {
                System.err.println("ignoring fill stipple");
                break;
            }
            default: {
                System.err.println("JGraphic.update: invalid graphic update");
            }
        }
    }
}

