/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.specialist;

import com.bbn.openmap.corba.CSpecialist.CTEntry;
import com.bbn.openmap.corba.CSpecialist.EComp;
import com.bbn.openmap.corba.CSpecialist.GraphicPackage.GF_update;
import com.bbn.openmap.corba.CSpecialist.LLPoint;
import com.bbn.openmap.corba.CSpecialist.RasterPackage.ERaster;
import com.bbn.openmap.corba.CSpecialist.RasterPackage.RASF_update;
import com.bbn.openmap.corba.CSpecialist.XYPoint;
import com.bbn.openmap.layer.specialist.JGraphic;
import com.bbn.openmap.layer.specialist.JObjectHolder;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.util.ColorFactory;
import java.awt.Color;
import java.io.Serializable;

public class JRaster
extends OMRaster
implements Serializable,
JObjectHolder {
    protected transient EComp object = null;
    protected int x_hot;
    protected int y_hot;

    public JRaster(ERaster eraster) {
        JGraphic.fillOMGraphicParams((OMGraphic)this, eraster.egraphic);
        this.setColorModel(1);
        this.x = eraster.p1.x;
        this.y = eraster.p1.y;
        this.lat = eraster.ll1.lat;
        this.lon = eraster.ll1.lon;
        this.height = eraster.height;
        this.width = eraster.width;
        this.bits = eraster.pixels;
        this.transparent = eraster.transparent & 0xFF;
        if ((eraster.transparent & 0xFF00) != 0) {
            this.scaleTo(eraster.x_hot, eraster.y_hot, 1);
        } else {
            this.x_hot = eraster.x_hot;
            this.y_hot = eraster.y_hot;
        }
        Color[] tmpColors = new Color[eraster.colorsTotal];
        for (int i = 0; i < eraster.colorsTotal; ++i) {
            tmpColors[i] = ColorFactory.createColor((int)eraster.ct[i].red, (int)eraster.ct[i].green, (int)eraster.ct[i].blue, (int)eraster.ct[i].open, (boolean)true);
        }
        this.setColors(tmpColors);
        this.setNeedToRegenerate(true);
    }

    public void setObject(EComp aObject) {
        this.object = aObject;
    }

    public EComp getObject() {
        return this.object;
    }

    public void update(GF_update update) {
        JGraphic.update(this, update);
    }

    public void update(RASF_update update) {
        this.setNeedToRegenerate(true);
        switch (update.discriminator().value()) {
            case 1: {
                LLPoint ll = update.ll1();
                this.lat = ll.lat;
                this.lon = ll.lon;
                break;
            }
            case 0: {
                XYPoint pt = update.p1();
                this.x = pt.x;
                this.y = pt.y;
                break;
            }
            case 3: {
                this.width = update.width();
                break;
            }
            case 4: {
                this.height = update.height();
                break;
            }
            case 5: {
                this.x_hot = update.x_hot();
                this.needToRegenerate = false;
                break;
            }
            case 6: {
                this.y_hot = update.y_hot();
                this.needToRegenerate = false;
                break;
            }
            case 2: {
                this.bits = update.pixels();
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                CTEntry[] ct = update.ct();
                Color[] tmpColors = new Color[ct.length];
                for (int i = 0; i < ct.length; ++i) {
                    tmpColors[i] = ColorFactory.createColor((int)ct[i].red, (int)ct[i].green, (int)ct[i].blue, (int)ct[i].open, (boolean)true);
                }
                this.setColors(tmpColors);
                break;
            }
            case 10: {
                this.transparent = update.transparent();
                break;
            }
            default: {
                System.err.println("JRaster.update: invalid raster update");
                this.setNeedToRegenerate(false);
            }
        }
    }
}

