/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.specialist;

import com.bbn.openmap.corba.CSpecialist.EComp;
import com.bbn.openmap.corba.CSpecialist.GraphicPackage.GF_update;
import com.bbn.openmap.corba.CSpecialist.LLPoint;
import com.bbn.openmap.corba.CSpecialist.RectanglePackage.ERectangle;
import com.bbn.openmap.corba.CSpecialist.RectanglePackage.RF_update;
import com.bbn.openmap.corba.CSpecialist.XYPoint;
import com.bbn.openmap.layer.specialist.JGraphic;
import com.bbn.openmap.layer.specialist.JObjectHolder;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMRect;
import java.io.Serializable;

public class JRect
extends OMRect
implements Serializable,
JObjectHolder {
    protected transient EComp object = null;

    public JRect(ERectangle erect) {
        JGraphic.fillOMGraphicParams((OMGraphic)this, erect.egraphic);
        this.x1 = erect.p1.x;
        this.y1 = erect.p1.y;
        this.x2 = erect.p2.x;
        this.y2 = erect.p2.y;
        this.lat1 = erect.ll1.lat;
        this.lon1 = erect.ll1.lon;
        this.lat2 = erect.ll2.lat;
        this.lon2 = erect.ll2.lon;
    }

    public void setObject(EComp aObject) {
        this.object = aObject;
    }

    public EComp getObject() {
        return this.object;
    }

    public void update(GF_update update) {
        JGraphic.update(this, update);
    }

    public void update(RF_update update) {
        switch (update.discriminator().value()) {
            case 2: {
                LLPoint ll1 = update.ll1();
                this.lat1 = ll1.lat;
                this.lon1 = ll1.lon;
                this.setNeedToRegenerate(true);
                break;
            }
            case 0: {
                XYPoint pt1 = update.p1();
                this.x1 = pt1.x;
                this.y1 = pt1.y;
                if (this.renderType == 1) break;
                this.setNeedToRegenerate(true);
                break;
            }
            case 3: {
                LLPoint ll2 = update.ll2();
                this.lat2 = ll2.lat;
                this.lon2 = ll2.lon;
                if (this.renderType != 1) break;
                this.setNeedToRegenerate(true);
                break;
            }
            case 1: {
                XYPoint pt2 = update.p2();
                this.x2 = pt2.x;
                this.y2 = pt2.y;
                if (this.renderType == 1) break;
                this.setNeedToRegenerate(true);
                break;
            }
            default: {
                System.err.println("JRect.update: invalid rect update");
            }
        }
    }
}

