/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.specialist.dted;

import com.bbn.openmap.corba.CSpecialist.CColorPackage.EColor;
import com.bbn.openmap.corba.CSpecialist.CProjection;
import com.bbn.openmap.corba.CSpecialist.GraphicChange;
import com.bbn.openmap.corba.CSpecialist.GraphicPackage.EGraphic;
import com.bbn.openmap.corba.CSpecialist.LLPoint;
import com.bbn.openmap.corba.CSpecialist.RectanglePackage.ERectangle;
import com.bbn.openmap.corba.CSpecialist.UGraphic;
import com.bbn.openmap.corba.CSpecialist.XYPoint;
import com.bbn.openmap.layer.dted.DTEDCoverageManager;
import com.bbn.openmap.layer.specialist.MakeProjection;
import com.bbn.openmap.layer.specialist.SGraphic;
import com.bbn.openmap.layer.specialist.Specialist;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.io.File;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.omg.CORBA.StringHolder;

public class DTEDCoverageSpecialist
extends Specialist {
    protected String[] paths = new String[]{"/mnt/cdrom/dted", "/mnt/disk/dted"};
    protected boolean showDTEDLevel0 = true;
    protected boolean showDTEDLevel1 = true;
    protected boolean showDTEDLevel2 = true;
    public static final Color defaultLevel0Color = new Color(13520703);
    public static final Color defaultLevel1Color = new Color(3379545);
    public static final Color defaultLevel2Color = new Color(816595);
    protected Color level0Color = defaultLevel0Color;
    protected Color level1Color = defaultLevel1Color;
    protected Color level2Color = defaultLevel2Color;
    protected int opaqueness = 255;
    protected boolean fillRects = false;
    protected String coverageFile = "/mnt/disk/coverage.dted";
    protected String coverageURL = null;
    protected DTEDCoverageManager coverageManager = null;
    protected boolean[][] level0Frames = new boolean[180][360];
    protected boolean[][] level1Frames = new boolean[180][360];
    protected boolean[][] level2Frames = new boolean[180][360];
    private static final transient XYPoint nullP1 = new XYPoint(0, 0);
    public static final String DTEDPathsProperty = ".paths";
    public static final String ShowLevel0Property = ".level0.showcov";
    public static final String Level0ColorProperty = ".level0.color";
    public static final String ShowLevel1Property = ".level1.showcov";
    public static final String Level1ColorProperty = ".level1.color";
    public static final String ShowLevel2Property = ".level2.showcov";
    public static final String Level2ColorProperty = ".level2.color";
    public static final String OpaquenessProperty = ".opaque";
    public static final String FillProperty = ".fill";
    public static final String CoverageFileProperty = ".coverageFile";
    public static final String CoverageURLProperty = ".coverageURL";

    public DTEDCoverageSpecialist() {
        super("DTEDCoverageSpecialist", (short)2, false);
    }

    protected void init() {
        System.out.println("DTEDCoverageSpecialist: Figuring out which DTED frames exist! (This is a one-time operation!)");
        System.out.println("Scanning for frames - This could take over (2) minutes!");
        this.coverageManager = new DTEDCoverageManager(this.paths);
    }

    public void setProperties(String prefix, Properties properties) {
        String showLevel2String;
        String showLevel1String;
        this.paths = this.initPathsFromProperties(properties.getProperty(prefix + DTEDPathsProperty));
        this.coverageFile = properties.getProperty(prefix + CoverageFileProperty);
        this.coverageURL = properties.getProperty(prefix + CoverageURLProperty);
        String fillString = properties.getProperty(prefix + FillProperty);
        if (fillString != null) {
            this.fillRects = Boolean.valueOf(fillString);
        }
        String opaqueString = properties.getProperty(prefix + OpaquenessProperty);
        try {
            this.opaqueness = Integer.valueOf(opaqueString);
        }
        catch (NumberFormatException e) {
            System.err.println("Unable to parse .opaque = " + opaqueString);
            this.opaqueness = 255;
        }
        this.level0Color = this.parseColor(properties, prefix + Level0ColorProperty, defaultLevel0Color);
        this.level1Color = this.parseColor(properties, prefix + Level1ColorProperty, defaultLevel1Color);
        this.level2Color = this.parseColor(properties, prefix + Level2ColorProperty, defaultLevel2Color);
        String showLevel0String = properties.getProperty(prefix + ShowLevel0Property);
        if (showLevel0String != null) {
            this.showDTEDLevel0 = Boolean.valueOf(showLevel0String);
        }
        if ((showLevel1String = properties.getProperty(prefix + ShowLevel1Property)) != null) {
            this.showDTEDLevel1 = Boolean.valueOf(showLevel1String);
        }
        if ((showLevel2String = properties.getProperty(prefix + ShowLevel2Property)) != null) {
            this.showDTEDLevel2 = Boolean.valueOf(showLevel2String);
        }
    }

    protected String[] initPathsFromProperties(String rawPaths) {
        String[] retPaths = null;
        if (rawPaths != null) {
            try {
                StringTokenizer token = new StringTokenizer(rawPaths, File.pathSeparator);
                int numPaths = token.countTokens();
                retPaths = new String[numPaths];
                for (int i = 0; i < numPaths; ++i) {
                    retPaths[i] = token.nextToken();
                }
                return retPaths;
            }
            catch (NoSuchElementException e) {
                e.printStackTrace();
            }
        }
        return retPaths;
    }

    protected Color parseColor(Properties p, String propName, Color dfault) {
        String colorString = p.getProperty(propName);
        if (colorString == null) {
            return dfault;
        }
        try {
            return this.parseColor(colorString);
        }
        catch (NumberFormatException e) {
            System.err.println("Unparseable number \"" + colorString + "\" in property \"" + propName + "\"");
            return dfault;
        }
    }

    protected Color parseColor(String colorString) throws NumberFormatException {
        int colorSpec = Integer.parseInt(colorString, 16);
        if (colorSpec < 0) {
            return OMGraphic.clear;
        }
        return new Color(colorSpec);
    }

    public UGraphic[] fillRectangle(CProjection p, LLPoint ll1, LLPoint ll2, String staticArgs, StringHolder dynamicArgs, GraphicChange notifyOnChange, String uniqueID) {
        System.out.println("DTEDCoverageSpecialist.fillRectangle()");
        Projection proj = MakeProjection.getProjection(p);
        OMGraphicList omGraphicLists = this.coverageManager.getCoverageRects(proj);
        if (omGraphicLists != null) {
            UGraphic[] level0UGraphics = null;
            UGraphic[] level1UGraphics = null;
            UGraphic[] level2UGraphics = null;
            if (this.showDTEDLevel0) {
                level0UGraphics = this.createUGraphics((OMGraphicList)omGraphicLists.get(0));
            }
            if (this.showDTEDLevel1) {
                level1UGraphics = this.createUGraphics((OMGraphicList)omGraphicLists.get(1));
            }
            if (this.showDTEDLevel2) {
                level2UGraphics = this.createUGraphics((OMGraphicList)omGraphicLists.get(2));
            }
            UGraphic[] ugraphics = new UGraphic[level0UGraphics.length + level1UGraphics.length + level2UGraphics.length];
            int off = 0;
            System.arraycopy(level0UGraphics, 0, ugraphics, off, level0UGraphics.length);
            System.arraycopy(level1UGraphics, 0, ugraphics, off += level0UGraphics.length, level1UGraphics.length);
            System.arraycopy(level2UGraphics, 0, ugraphics, off += level1UGraphics.length, level2UGraphics.length);
            System.out.println("DTEDCoverageSpecialist.fillRectangle(): returning " + ugraphics.length + " graphics");
            return ugraphics;
        }
        System.out.println("DTEDCoverageSpecialist.fillRectangle(): finished with null graphics list");
        return new UGraphic[0];
    }

    public void signOff(String uniqueID) {
        System.out.println("DTEDCoverageSpecialist.signOff()");
    }

    protected UGraphic[] createUGraphics(OMGraphicList omgraphics) {
        int len = omgraphics.size();
        UGraphic[] ugraphics = new UGraphic[len];
        for (int i = 0; i < len; ++i) {
            OMGraphic gr = omgraphics.getOMGraphicAt(i);
            if (gr instanceof OMRect) {
                OMRect omr = (OMRect)gr;
                EGraphic eg = SGraphic.createEGraphic();
                int lineColor = omr.getLineColor().getRGB();
                eg.color = new EColor(null, (short)((lineColor & 0xFF0000) >> 8), (short)(lineColor & 0xFF00), (short)((lineColor & 0xFF) << 8));
                if (this.fillRects) {
                    int fillColor = omr.getFillColor().getRGB();
                    eg.fillColor = new EColor(null, (short)((fillColor & 0xFF0000) >> 8), (short)(fillColor & 0xFF00), (short)((fillColor & 0xFF) << 8));
                }
                ERectangle er = new ERectangle(eg, nullP1, nullP1, new LLPoint((float)omr.getNorthLat(), (float)omr.getWestLon()), new LLPoint((float)omr.getSouthLat(), (float)omr.getEastLon()));
                UGraphic ug = new UGraphic();
                ug.erect(er);
                ugraphics[i] = ug;
                continue;
            }
            UGraphic[] x_ugraphics = this.createUGraphics((OMGraphicList)gr);
            len = x_ugraphics.length + ugraphics.length - 1;
            UGraphic[] new_ugraphics = new UGraphic[len];
            System.arraycopy(ugraphics, 0, new_ugraphics, 0, i);
            System.arraycopy(x_ugraphics, 0, new_ugraphics, i, x_ugraphics.length);
            i += x_ugraphics.length;
            ugraphics = new_ugraphics;
        }
        return ugraphics;
    }

    public void printHelp() {
        System.err.println("usage: java [java/vbj args] <specialist class> [specialist args]");
        System.err.println("");
        System.err.println("       Java Args:");
        System.err.println("       -mx<NUM>m               Set max Java heap in Megs");
        System.err.println("       ...");
        System.err.println("");
        System.err.println("       VBJ Args:");
        System.err.println("       -DORBmbufSize=4194304   Define the VBJ buffer size");
        System.err.println("       -DORBdebug              Enable VBJ debugging");
        System.err.println("       ...");
        System.err.println("");
        System.err.println("       Specialist Args:");
        System.err.println("       -ior <iorfile>                  IOR file (MUST SPECIFY)");
        System.err.println("       -covfile <covfile>              Coverage file (R/W)");
        System.err.println("       -dtedpaths \"<path1> ...\"      Path to search for DTED data");
        System.err.println("       -dted2paths \"<path1> ...\"     Path to search for DTED level2 data");
        System.exit(1);
    }

    private String[] getPaths(String str) {
        StringTokenizer tok = new StringTokenizer(str);
        int len = tok.countTokens();
        String[] paths = new String[len];
        for (int j = 0; j < len; ++j) {
            paths[j] = tok.nextToken();
        }
        return paths;
    }

    public void parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-dtedpaths")) {
                this.paths = this.getPaths(args[++i]);
                continue;
            }
            if (!args[i].equalsIgnoreCase("-covfile")) continue;
            this.coverageFile = args[++i];
        }
        super.parseArgs(args);
    }

    public static void main(String[] args) {
        Debug.init((Properties)System.getProperties());
        DTEDCoverageSpecialist srv = new DTEDCoverageSpecialist();
        srv.parseArgs(args);
        srv.init();
        srv.start(null);
    }
}

