/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.specialist.dted;

import com.bbn.openmap.corba.CSpecialist.CColorPackage.EColor;
import com.bbn.openmap.corba.CSpecialist.CProjection;
import com.bbn.openmap.corba.CSpecialist.CStipplePackage.EStipple;
import com.bbn.openmap.corba.CSpecialist.CTEntry;
import com.bbn.openmap.corba.CSpecialist.EComp;
import com.bbn.openmap.corba.CSpecialist.GraphicChange;
import com.bbn.openmap.corba.CSpecialist.GraphicPackage.DeclutterType;
import com.bbn.openmap.corba.CSpecialist.GraphicPackage.EGraphic;
import com.bbn.openmap.corba.CSpecialist.GraphicPackage.GraphicType;
import com.bbn.openmap.corba.CSpecialist.GraphicPackage.LineType;
import com.bbn.openmap.corba.CSpecialist.GraphicPackage.RenderType;
import com.bbn.openmap.corba.CSpecialist.LLPoint;
import com.bbn.openmap.corba.CSpecialist.MouseEvent;
import com.bbn.openmap.corba.CSpecialist.RasterPackage.ERaster;
import com.bbn.openmap.corba.CSpecialist.UGraphic;
import com.bbn.openmap.corba.CSpecialist.WidgetChange;
import com.bbn.openmap.corba.CSpecialist.XYPoint;
import com.bbn.openmap.layer.dted.DTEDCacheManager;
import com.bbn.openmap.layer.dted.DTEDFrameSubframeInfo;
import com.bbn.openmap.layer.specialist.MakeProjection;
import com.bbn.openmap.layer.specialist.Specialist;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.proj.CADRG;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.util.Properties;
import java.util.StringTokenizer;
import org.omg.CORBA.StringHolder;

public class DTEDSpecialist
extends Specialist {
    protected String[] dtedpaths = new String[]{"/mnt/cdrom/dted", "/mnt/disk/dted"};
    protected int ncolors = 216;
    protected int opaque = 255;
    protected DTEDCacheManager cache_manager;
    protected int dtedLevel = 0;
    protected int viewType = 5;
    protected int bandHeight = 25;
    protected int slopeAdjust = 3;
    protected float minScale = 2.0E7f;
    private static final transient EColor nullColor = new EColor(null, 0, 0, 0);
    private static final transient EStipple nullStipple = new EStipple(null, 0, 0, new byte[0]);
    private static final transient EComp nullComp = new EComp(null, "");
    private static final transient XYPoint nullP1 = new XYPoint(0, 0);
    private static int gid = 0;

    public DTEDSpecialist() {
        super("DTEDSpecialist", (short)2, true);
    }

    protected void init() {
        this.cache_manager = new DTEDCacheManager(this.dtedpaths, this.ncolors, this.opaque);
        DTEDFrameSubframeInfo dfsi = new DTEDFrameSubframeInfo(this.viewType, this.bandHeight, this.dtedLevel, this.slopeAdjust);
        dfsi.colorModel = 1;
        this.cache_manager.setSubframeInfo(dfsi);
    }

    public UGraphic[] fillRectangle(CProjection p, LLPoint ll1, LLPoint ll2, String staticArgs, StringHolder dynamicArgs, GraphicChange notifyOnChange, String uniqueID) {
        System.out.println("DTEDSpecialist.fillRectangle()");
        try {
            if (p.kind != 1 || !((float)p.scale < this.minScale)) {
                System.out.println("DTEDSpecialist.fillRectangle(): wrong projection!");
                return new UGraphic[0];
            }
            OMGraphicList omgraphics = this.cache_manager.getRectangle((Projection)((CADRG)MakeProjection.getProjection(p)));
            UGraphic[] ugraphics = this.createUGraphics(omgraphics);
            System.out.println("DTEDSpecialist.fillRectangle(): got " + ugraphics.length + " graphics");
            return ugraphics;
        }
        catch (Throwable t) {
            System.err.println("DTEDSpecialist.fillRectangle(): " + t);
            t.printStackTrace();
            throw new RuntimeException();
        }
    }

    protected UGraphic[] createUGraphics(OMGraphicList omgraphics) {
        int len = omgraphics.size();
        UGraphic[] ugraphics = new UGraphic[len];
        for (int i = 0; i < len; ++i) {
            OMRaster omr = (OMRaster)omgraphics.getOMGraphicAt(i);
            EGraphic eg = this.createEGraphic();
            CTEntry[] ct = this.createColorTable(omr.getColors());
            ERaster er = new ERaster(eg, nullP1, new LLPoint((float)omr.getLat(), (float)omr.getLon()), omr.getBits(), (short)omr.getWidth(), (short)omr.getHeight(), 0, 0, (short)ct.length, ct, (short)omr.getTransparent());
            UGraphic ug = new UGraphic();
            ug.eras(er);
            ugraphics[i] = ug;
        }
        return ugraphics;
    }

    protected EGraphic createEGraphic() {
        EGraphic eg = new EGraphic();
        eg.graph = null;
        eg.obj = nullComp;
        eg.gType = GraphicType.GT_Raster;
        eg.rType = RenderType.RT_LatLon;
        eg.lType = LineType.LT_Unknown;
        eg.dcType = DeclutterType.DC_None;
        eg.lineWidth = 1;
        eg.gID = Long.toString(gid++);
        eg.color = nullColor;
        eg.fillColor = nullColor;
        eg.stipple = nullStipple;
        eg.fillStipple = nullStipple;
        return eg;
    }

    protected CTEntry[] createColorTable(int[] colors) {
        int len = colors.length;
        CTEntry[] colorTable = new CTEntry[len];
        for (int i = 0; i < len; ++i) {
            colorTable[i] = new CTEntry((short)(colors[i] >> 16 & 0xFF), (short)(colors[i] >> 8 & 0xFF), (short)(colors[i] & 0xFF), (short)(colors[i] >> 24 & 0xFF));
        }
        return colorTable;
    }

    public void signOff(String uniqueID) {
        System.out.println("DTEDSpecialist.signOff()");
    }

    public void receiveGesture(MouseEvent gesture, String uniqueID) {
    }

    public void makePalette(WidgetChange notifyOnChange, String staticArgs, StringHolder dynamicArgs, String uniqueID) {
    }

    public void printHelp() {
        System.err.println("usage: java [java/vbj args] <specialist class> [specialist args]");
        System.err.println("");
        System.err.println("       Java Args:");
        System.err.println("       -mx<NUM>m               Set max Java heap in Megs");
        System.err.println("");
        System.err.println("       VBJ Args:");
        System.err.println("       -DORBmbufSize=8388608   Define the VBJ buffer size");
        System.err.println("       -DORBdebug              Enable VBJ debugging");
        System.err.println("");
        System.err.println("       Specialist Args:");
        System.err.println("       -ior <iorfile>                  IOR file");
        System.err.println("       -dtedpaths \"<path1> ...\"      Path to search for DTED data");
        System.err.println("       -level <0|1|2>                  DTED level (default is 0)");
    }

    private String[] getPaths(String str) {
        StringTokenizer tok = new StringTokenizer(str);
        int len = tok.countTokens();
        String[] paths = new String[len];
        for (int j = 0; j < len; ++j) {
            paths[j] = tok.nextToken();
        }
        return paths;
    }

    public void parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-dtedpaths")) {
                this.dtedpaths = this.getPaths(args[++i]);
                continue;
            }
            if (!args[i].equalsIgnoreCase("-level")) continue;
            this.dtedLevel = Integer.parseInt(args[++i]);
            System.out.println("Setting level " + this.dtedLevel);
        }
        super.parseArgs(args);
    }

    public static void main(String[] args) {
        Debug.init((Properties)System.getProperties());
        DTEDSpecialist srv = new DTEDSpecialist();
        srv.parseArgs(args);
        srv.init();
        srv.start(args);
    }
}

