/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.specialist.shape;

import com.bbn.openmap.Environment;
import com.bbn.openmap.corba.CSpecialist.CProjection;
import com.bbn.openmap.corba.CSpecialist.GraphicChange;
import com.bbn.openmap.corba.CSpecialist.LLPoint;
import com.bbn.openmap.corba.CSpecialist.MouseEvent;
import com.bbn.openmap.corba.CSpecialist.UGraphic;
import com.bbn.openmap.corba.CSpecialist.WidgetChange;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.shape.ESRIRecord;
import com.bbn.openmap.layer.specialist.SColor;
import com.bbn.openmap.layer.specialist.SGraphic;
import com.bbn.openmap.layer.specialist.Specialist;
import com.bbn.openmap.layer.specialist.shape.ESRISpecialistRecord;
import com.bbn.openmap.layer.specialist.shape.SpecialistSpatialIndex;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import org.omg.CORBA.StringHolder;

public class ShapeSpecialist
extends Specialist {
    public static final String shapeFileProperty = "shapeFile";
    public static final String spatialIndexProperty = "spatialIndex";
    public static final String lineColorProperty = "lineColor";
    public static final String fillColorProperty = "fillColor";
    protected SpecialistSpatialIndex spatialIndex;
    protected Properties properties = null;
    protected SColor lineColor = null;
    protected SColor fillColor = null;

    public ShapeSpecialist() {
        super("ShapeSpecialist", (short)2, false);
    }

    public ShapeSpecialist(String shapeFile, String spatialIndexFile) {
        super("ShapeSpecialist", (short)2, false);
        this.init(shapeFile, spatialIndexFile);
    }

    public void init(String shapeFile, String spatialIndexFile) {
        this.spatialIndex = this.locateAndSetShapeData(shapeFile, spatialIndexFile);
    }

    protected Vector computeGraphics(LLPoint ll1, LLPoint ll2) {
        if (this.spatialIndex == null) {
            return new Vector();
        }
        Vector list = null;
        if (ProjMath.isCrossingDateline((double)ll1.lon, (double)ll2.lon, (float)1000000.0f)) {
            if (Debug.debugging((String)"shape")) {
                Debug.output((String)"Dateline is on screen");
            }
            double ymin = Math.min(ll1.lat, ll2.lat);
            double ymax = Math.max(ll1.lat, ll2.lat);
            try {
                int i;
                ESRIRecord[] records1 = this.spatialIndex.locateRecords(ll1.lon, ymin, 180.0, ymax);
                ESRIRecord[] records2 = this.spatialIndex.locateRecords(-180.0, ymin, ll2.lon, ymax);
                int nRecords1 = records1.length;
                int nRecords2 = records2.length;
                list = new Vector(nRecords1 + nRecords2);
                for (i = 0; i < nRecords1; ++i) {
                    ((ESRISpecialistRecord)records1[i]).writeGraphics(list, this.lineColor, this.fillColor);
                }
                for (i = 0; i < nRecords2; ++i) {
                    ((ESRISpecialistRecord)records2[i]).writeGraphics(list, this.lineColor, this.fillColor);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (FormatException fe) {
                fe.printStackTrace();
            }
        } else {
            double xmin = Math.min(ll1.lon, ll2.lon);
            double xmax = Math.max(ll1.lon, ll2.lon);
            double ymin = Math.min(ll1.lat, ll2.lat);
            double ymax = Math.max(ll1.lat, ll2.lat);
            try {
                ESRIRecord[] records = this.spatialIndex.locateRecords(xmin, ymin, xmax, ymax);
                int nRecords = records.length;
                list = new Vector(nRecords);
                for (int i = 0; i < nRecords; ++i) {
                    ((ESRISpecialistRecord)records[i]).writeGraphics(list, this.lineColor, this.fillColor);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (FormatException fe) {
                fe.printStackTrace();
            }
        }
        return list;
    }

    public UGraphic[] fillRectangle(CProjection p, LLPoint ll1, LLPoint ll2, String staticArgs, StringHolder dynamicArgs, GraphicChange notifyOnChange, String uniqueID) {
        try {
            Vector list = this.computeGraphics(ll1, ll2);
            int len = list.size();
            UGraphic[] ugraphics = new UGraphic[len];
            for (int i = 0; i < len; ++i) {
                SGraphic sg = (SGraphic)list.elementAt(i);
                ugraphics[i] = sg.ufill();
            }
            return ugraphics;
        }
        catch (Throwable t) {
            System.err.println("ShapeSpecialist.fillRectangle(): " + t);
            t.printStackTrace();
            return new UGraphic[0];
        }
    }

    protected SpecialistSpatialIndex locateAndSetShapeData(String shapeFileName, String spatialIndexFileName) {
        File spatialIndexFile = new File(spatialIndexFileName);
        SpecialistSpatialIndex si = null;
        if (spatialIndexFile.isAbsolute()) {
            try {
                si = new SpecialistSpatialIndex(spatialIndexFileName, shapeFileName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            Vector dirs = Environment.getClasspathDirs();
            int nDirs = dirs.size();
            if (nDirs > 0) {
                for (String dir : dirs) {
                    File sif = new File(dir, spatialIndexFileName);
                    if (!sif.isFile()) continue;
                    File sf = new File(dir, shapeFileName);
                    try {
                        si = new SpecialistSpatialIndex(sif.toString(), sf.toString());
                        break;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (si == null) {
                    System.err.println("Unable to find file: " + shapeFileName);
                    System.err.println("Unable to find file: " + spatialIndexFileName);
                }
            } else {
                System.err.println("No directories in CLASSPATH!");
                System.err.println("Unable to locate file: " + shapeFileName);
                System.err.println("Unable to locate file: " + spatialIndexFileName);
            }
        }
        return si;
    }

    public void signOff(String uniqueID) {
        System.out.println("ShapeSpecialist.signOff()");
    }

    public void receiveGesture(MouseEvent gesture, String uniqueID) {
    }

    public void makePalette(WidgetChange notifyOnChange, String staticArgs, StringHolder dynamicArgs, String uniqueID) {
    }

    public void printHelp() {
        System.err.println("usage: java [java/vbj args] <specialist class> [specialist args]");
        System.err.println("");
        System.err.println("       Java Args:");
        System.err.println("       -mx<NUM>m               Set max Java heap in Megs");
        System.err.println("");
        System.err.println("       VBJ Args:");
        System.err.println("       -DORBmbufSize=8388608   Define the VBJ buffer size");
        System.err.println("       -DORBdebug              Enable VBJ debugging");
        System.err.println("");
        System.err.println("       Specialist Args:");
        System.err.println("       -ior <iorfile>                  IOR file");
        System.err.println("       -properties \"<file> ...\"      Path to properties file");
    }

    public void parseArgs(String[] args) {
        Color lcolor = null;
        Color fcolor = null;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase("-properties") || args.length <= i + 1) continue;
            this.properties = this.loadProps(args[i + 1]);
            lcolor = PropUtils.parseColorFromProperties((Properties)this.properties, (String)lineColorProperty, (String)"FF000000");
            this.lineColor = new SColor((short)(lcolor.getRed() * 65535 / 255), (short)(lcolor.getGreen() * 65535 / 255), (short)(lcolor.getBlue() * 65535 / 255));
            if (this.properties.getProperty(fillColorProperty) != null) {
                fcolor = PropUtils.parseColorFromProperties((Properties)this.properties, (String)fillColorProperty, (String)"FF000000");
                this.fillColor = new SColor((short)(fcolor.getRed() * 65535 / 255), (short)(fcolor.getGreen() * 65535 / 255), (short)(fcolor.getBlue() * 65535 / 255));
            }
            String ssx = this.properties.getProperty(spatialIndexProperty);
            String shp = this.properties.getProperty(shapeFileProperty);
            this.init(shp, ssx);
        }
        if (this.properties == null) {
            System.out.println("Need properties file!");
            System.out.println("");
            System.out.println("#######################################");
            System.out.println("shapeFile=<path to shape file (.shp)>");
            System.out.println("spatialIndex=<path to spatial index file (.ssx)>");
            System.out.println("lineColor=<hex ARGB color> i.e. FF000000 for black");
            System.out.println("fillColor=<hex ARGB color> i.e. FF000000 for black>");
            System.out.println("#######################################");
            System.out.println("");
            this.printHelp();
            System.exit(0);
        }
        super.parseArgs(args);
        System.out.println("Using colors -> lcolor = " + lcolor + ", fcolor = " + fcolor);
    }

    public Properties loadProps(String file) {
        File propsFile = new File(file);
        Properties props = new Properties();
        try {
            FileInputStream propsStream = new FileInputStream(propsFile);
            props.load(propsStream);
        }
        catch (FileNotFoundException e) {
            System.err.println("ShapeSpecialist did not find properties file: \"" + file + "\"");
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("Caught IO Exception reading configuration file \"" + propsFile + "\"");
            e.printStackTrace();
            System.exit(1);
        }
        return props;
    }

    public static void main(String[] args) {
        Debug.init((Properties)System.getProperties());
        ShapeSpecialist srv = new ShapeSpecialist();
        srv.parseArgs(args);
        srv.start(args);
    }
}

