/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.specialist.vpf;

import com.bbn.openmap.MoreMath;
import com.bbn.openmap.corba.CSpecialist.Comp;
import com.bbn.openmap.corba.CSpecialist.GraphicPackage.LineType;
import com.bbn.openmap.corba.CSpecialist.GraphicPackage.RenderType;
import com.bbn.openmap.corba.CSpecialist.LLPoint;
import com.bbn.openmap.corba.CSpecialist.UGraphic;
import com.bbn.openmap.layer.specialist.GraphicList;
import com.bbn.openmap.layer.specialist.SColor;
import com.bbn.openmap.layer.specialist.SPoly;
import com.bbn.openmap.layer.specialist.SText;
import com.bbn.openmap.layer.vpf.CoordFloatString;
import com.bbn.openmap.layer.vpf.LibrarySelectionTable;
import com.bbn.openmap.layer.vpf.VPFGraphicWarehouse;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GraphicWarehouseSupport
implements VPFGraphicWarehouse {
    protected static final transient float antarcticaThreshold = -89.9f;
    protected GraphicList graphics;
    private boolean drawEdgeFeatures;
    private boolean drawTextFeatures;
    private boolean drawAreaFeatures;
    private boolean drawPointFeatures;
    SColor[] edgeColors = new SColor[]{new SColor(-1, 0, 0), new SColor(0, -1, 0), new SColor(0, 0, -1), new SColor(Short.MIN_VALUE, Short.MIN_VALUE, Short.MIN_VALUE), new SColor(-1, -1, -1)};
    protected static SColor[] textColors = new SColor[]{new SColor(-3316, -23716, 24480), new SColor(-11986, -19636, -29836), new SColor(-11986, 26775, 7650), new SColor(-17596, -29071, -29071), new SColor(-13261, 23460, 23460), new SColor(-20146, 8670, 8670)};
    private static SColor[] cmap = null;
    private List<String> useLibrary = null;

    public GraphicWarehouseSupport() {
        this.graphics = new GraphicList();
    }

    public void resetForCAT() {
    }

    public Component getGUI(LibrarySelectionTable lst) {
        return null;
    }

    public void setEdgeFeatures(boolean newvalue) {
        this.drawEdgeFeatures = newvalue;
    }

    public boolean drawEdgeFeatures() {
        return this.drawEdgeFeatures;
    }

    public void setTextFeatures(boolean newvalue) {
        this.drawTextFeatures = newvalue;
    }

    public boolean drawTextFeatures() {
        return this.drawTextFeatures;
    }

    public void setAreaFeatures(boolean newvalue) {
        Debug.message((String)"vpfspecialist", (String)("Setting area features to " + newvalue));
        this.drawAreaFeatures = newvalue;
    }

    public boolean drawAreaFeatures() {
        return this.drawAreaFeatures;
    }

    public void setPointFeatures(boolean newvalue) {
        this.drawPointFeatures = newvalue;
    }

    public boolean drawPointFeatures() {
        return this.drawPointFeatures;
    }

    protected SPoly createAreaSPoly(List jpts, int totalSize, LatLonPoint ll1, LatLonPoint ll2, float dpplat, float dpplon) {
        int size = jpts.size();
        ArrayList<LLPoint> ipts = new ArrayList<LLPoint>(size * 2);
        for (int j = 0; j < size; ++j) {
            int i;
            CoordFloatString cfs = (CoordFloatString)jpts.get(j);
            int cfscnt = cfs.tcount;
            int cfssz = cfs.tsize;
            double[] cfsvals = cfs.vals;
            if (cfscnt > 0) {
                for (i = 0; i < cfscnt; ++i) {
                    ipts.add(new LLPoint((float)cfsvals[i * cfssz + 1], (float)cfsvals[i * cfssz]));
                }
                continue;
            }
            for (i = (cfscnt *= -1) - 1; i >= 0; --i) {
                ipts.add(new LLPoint((float)cfsvals[i * cfssz + 1], (float)cfsvals[i * cfssz]));
            }
        }
        LLPoint[] pts = this.generatePolyPts(ipts, ll1.getLatitude(), ll2.getLatitude(), ll2.getLongitude(), ll1.getLongitude(), dpplat, dpplon);
        if (pts == null) {
            return null;
        }
        SPoly py = new SPoly(pts, LineType.LT_Straight);
        return py;
    }

    public LLPoint[] generatePolyPts(List ipts, float north, float south, float east, float west, float dpplat, float dpplon) {
        int coordcount = ipts.size();
        Vector<LLPoint> vPts = new Vector<LLPoint>(coordcount, 5);
        boolean weaseledOurWayAroundAntarcticAnomaly = south >= -62.0f;
        LLPoint prevPt = null;
        for (int i = 0; i < coordcount; ++i) {
            LLPoint pt = (LLPoint)ipts.get(i);
            float lllat = pt.lat;
            if (prevPt != null && i != coordcount - 1 && Math.abs(prevPt.lat - pt.lat) < dpplat && Math.abs(prevPt.lon - pt.lon) < dpplon) continue;
            vPts.add(pt);
            prevPt = pt;
            if (weaseledOurWayAroundAntarcticAnomaly || !(lllat < -89.9f)) continue;
            weaseledOurWayAroundAntarcticAnomaly = true;
            System.out.println("AreaTable.generateSPoly(): Antarctica!");
            vPts.add(new LLPoint(-89.99f, 179.99f));
            vPts.add(new LLPoint(-89.99f, 90.0f));
            vPts.add(new LLPoint(-89.99f, 0.0f));
            vPts.add(new LLPoint(-89.99f, -90.0f));
            vPts.add(new LLPoint(-89.99f, -179.99f));
            prevPt = (LLPoint)vPts.lastElement();
            while (((LLPoint)ipts.get((int)i)).lon > 0.0f) {
                ++i;
            }
        }
        int nPts = vPts.size();
        if (nPts == 0) {
            return null;
        }
        Object[] pts = new LLPoint[nPts];
        vPts.copyInto(pts);
        return pts;
    }

    public SPoly createEdgeSPoly(CoordFloatString coords, LatLonPoint ll1, LatLonPoint ll2, float dpplat, float dpplon) {
        LLPoint[] pts = this.clipToScreen(coords, ll1.getLatitude(), ll2.getLatitude(), ll2.getLongitude(), ll1.getLongitude(), dpplat, dpplon);
        if (pts == null) {
            return null;
        }
        SPoly py = new SPoly(pts, LineType.LT_Straight);
        return py;
    }

    public LLPoint[] clipToScreen(CoordFloatString cfs, float north, float south, float east, float west, float dpplat, float dpplon) {
        LLPoint[] pts = new LLPoint[cfs.maxIndex()];
        int lpcount = 0;
        int outcount = 0;
        int elimscale = 0;
        double[] cfslls = cfs.vals;
        int cfstupsize = cfs.tsize;
        for (int i = 0; i < pts.length; ++i) {
            double lllon = cfslls[cfstupsize * i];
            double lllat = cfslls[cfstupsize * i + 1];
            if (lllat < (double)south || lllat > (double)north || west < east && (lllon < (double)west || lllon > (double)east) || west > east && lllon < (double)west && lllon > (double)east) {
                if (lpcount > 1 && ++outcount > 2 || lpcount == 1 && outcount > 1) {
                    pts[lpcount] = new LLPoint((float)lllat, (float)lllon);
                    continue;
                }
            } else {
                outcount = 0;
            }
            if (lpcount > 0 && i != pts.length - 1 && Math.abs((double)pts[lpcount - 1].lat - lllat) < (double)dpplat && Math.abs((double)pts[lpcount - 1].lon - lllon) < (double)dpplon) {
                ++elimscale;
                continue;
            }
            pts[lpcount++] = new LLPoint((float)lllat, (float)lllon);
        }
        if (lpcount == 1 && outcount > 0) {
            lpcount = 0;
        }
        if (lpcount != cfs.maxIndex()) {
            LLPoint[] newpts = new LLPoint[lpcount];
            System.arraycopy(pts, 0, newpts, 0, lpcount);
            pts = newpts;
        }
        if (pts.length == 0) {
            return null;
        }
        return pts;
    }

    public LLPoint[] clipToScreen_tcm(CoordFloatString cfs, float north, float south, float east, float west, float dpplat, float dpplon) {
        if (west > east) {
            // empty if block
        }
        if (west < east && MoreMath.approximately_equal((float)east, (float)west, (float)0.001f)) {
            float tmp = west;
            west = east;
            east = tmp;
        }
        LLPoint[] pts = new LLPoint[cfs.maxIndex()];
        int lpcount = 0;
        int outcount = 0;
        int elimscale = 0;
        double[] cfslls = cfs.vals;
        int cfstupsize = cfs.tsize;
        for (int i = 0; i < pts.length; ++i) {
            double lllon = cfslls[cfstupsize * i];
            double lllat = cfslls[cfstupsize * i + 1];
            if (lllat < (double)south || lllat > (double)north || west < east && (lllon < (double)west || lllon > (double)east) || west > east && lllon < (double)west && lllon > (double)east) {
                if (lpcount > 1 && ++outcount > 2 || lpcount == 1 && outcount > 1) {
                    pts[lpcount] = new LLPoint((float)lllat, (float)lllon);
                    continue;
                }
            } else {
                outcount = 0;
            }
            if (lpcount > 0 && i != pts.length - 1 && Math.abs((double)pts[lpcount - 1].lat - lllat) < (double)dpplat && Math.abs((double)pts[lpcount - 1].lon - lllon) < (double)dpplon) {
                ++elimscale;
                continue;
            }
            pts[lpcount++] = new LLPoint((float)lllat, (float)lllon);
        }
        if (lpcount == 1 && outcount > 0) {
            lpcount = 0;
        }
        if (lpcount != cfs.maxIndex()) {
            LLPoint[] newpts = new LLPoint[lpcount];
            System.arraycopy(pts, 0, newpts, 0, lpcount);
            pts = newpts;
        }
        if (pts.length == 0) {
            return null;
        }
        return pts;
    }

    public SText createTextSText(String text, float latitude, float longitude) {
        SText py = new SText();
        py.rType(RenderType.RT_LatLon);
        py.data(text);
        py.ll1(new LLPoint(latitude, longitude));
        return py;
    }

    public UGraphic[] packGraphics() {
        return this.graphics.packGraphics();
    }

    Comp[] getComps() {
        return this.graphics.getComps();
    }

    public static SColor ns(Color color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        return GraphicWarehouseSupport.ns(r, g, b);
    }

    private static SColor ns(int r, int g, int b) {
        return new SColor((short)(r * 256), (short)(g * 256), (short)(b * 256));
    }

    public static SColor getSColor(int place) {
        if (cmap == null) {
            cmap = new SColor[8];
            GraphicWarehouseSupport.cmap[0] = GraphicWarehouseSupport.ns(205, 192, 176);
            GraphicWarehouseSupport.cmap[1] = GraphicWarehouseSupport.ns(255, 192, 203);
            GraphicWarehouseSupport.cmap[2] = GraphicWarehouseSupport.ns(221, 160, 221);
            GraphicWarehouseSupport.cmap[3] = GraphicWarehouseSupport.ns(162, 205, 90);
            GraphicWarehouseSupport.cmap[4] = GraphicWarehouseSupport.ns(255, 218, 185);
            GraphicWarehouseSupport.cmap[5] = GraphicWarehouseSupport.ns(255, 160, 122);
            GraphicWarehouseSupport.cmap[6] = GraphicWarehouseSupport.ns(205, 201, 165);
            GraphicWarehouseSupport.cmap[7] = GraphicWarehouseSupport.ns(216, 191, 216);
        }
        return cmap[place % cmap.length];
    }

    public boolean drawEPointFeatures() {
        return false;
    }

    public boolean drawCPointFeatures() {
        return false;
    }

    public List getFeatures() {
        return new ArrayList();
    }

    public void setUseLibrary(String lib) {
        this.useLibrary = new ArrayList<String>();
        this.useLibrary.add(lib);
    }

    public String getUseLibrary() {
        if (this.useLibrary != null && this.useLibrary.size() > 0) {
            return this.useLibrary.get(0);
        }
        return null;
    }

    public void setUseLibraries(List<String> libNames) {
        this.useLibrary = libNames;
    }

    public List<String> getUseLibraries() {
        return this.useLibrary;
    }

    public boolean checkLibraryForUsage(String libName) {
        boolean useLibrary = true;
        List<String> libraryNames = this.getUseLibraries();
        if (libraryNames != null && libraryNames.size() > 0) {
            useLibrary = false;
            for (String libraryName : libraryNames) {
                if (!libName.startsWith(libraryName)) continue;
                useLibrary = true;
                break;
            }
        }
        return useLibrary;
    }
}

