/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.specialist.vpf;

import com.bbn.openmap.MoreMath;
import com.bbn.openmap.corba.CSpecialist.CProjection;
import com.bbn.openmap.corba.CSpecialist.CheckButton;
import com.bbn.openmap.corba.CSpecialist.Comp;
import com.bbn.openmap.corba.CSpecialist.GraphicChange;
import com.bbn.openmap.corba.CSpecialist.LLPoint;
import com.bbn.openmap.corba.CSpecialist.MouseEvent;
import com.bbn.openmap.corba.CSpecialist.UGraphic;
import com.bbn.openmap.corba.CSpecialist.WidgetChange;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.specialist.SCheckBox;
import com.bbn.openmap.layer.specialist.Specialist;
import com.bbn.openmap.layer.specialist.vpf.TableListener;
import com.bbn.openmap.layer.specialist.vpf.UsefulCheckbox;
import com.bbn.openmap.layer.specialist.vpf.VPFSpecialistGraphicWarehouse;
import com.bbn.openmap.layer.vpf.LibrarySelectionTable;
import com.bbn.openmap.layer.vpf.VPFGraphicWarehouse;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.http.HttpRequestListener;
import com.bbn.openmap.util.http.HttpServer;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.omg.CORBA.StringHolder;

public class VPFSpecialist
extends Specialist {
    private String dcwpath;
    private Hashtable checkboxes = new Hashtable();
    private LibrarySelectionTable lst;
    private Hashtable comphash = new Hashtable();
    public static final String prefix = "VPFSpec";
    public static final float altCovScale = 3.0E7f;
    public static final String DynArgEdges = "edges";
    public static final String DynArgText = "text";
    public static final String DynArgArea = "area";

    public VPFSpecialist() {
        super("VPFSpecialist", (short)2, true);
        this.initDcwFiles();
    }

    public VPFSpecialist(LibrarySelectionTable libtab) {
        super("VPFSpecialist", (short)2, true);
        this.lst = libtab;
    }

    public VPFSpecialist(File dcwDataPath) {
        super("VPFSpecialist", (short)2, true);
        this.dcwpath = dcwDataPath.getAbsolutePath();
        this.initDcwFiles();
    }

    public VPFSpecialist(String name) {
        super(name, (short)2, true);
    }

    public Properties processTokens(String args, StringBuffer cov, StringBuffer altcov, boolean usealt) {
        StringTokenizer tok = new StringTokenizer(args, ")");
        String token = null;
        Properties props = new Properties();
        try {
            while (true) {
                token = tok.nextToken();
                if ((token = token.trim()).startsWith("(")) {
                    token = token.substring(1, token.length());
                    int comma = token.indexOf(",");
                    String key = token.substring(0, comma);
                    String value = token.substring(comma + 1, token.length());
                    key = key.trim();
                    value = value.trim();
                    if (key.equals("coverageType")) {
                        int spacedelim = value.indexOf(" ");
                        if (spacedelim == -1) {
                            cov.delete(0, cov.length());
                            cov = cov.append(value);
                            altcov = altcov.delete(0, altcov.length());
                            altcov.append("");
                        } else {
                            cov.delete(0, cov.length());
                            cov = cov.append(value.substring(0, spacedelim));
                            altcov = altcov.delete(0, altcov.length());
                            altcov = altcov.append(value.substring(spacedelim + 1, value.length()));
                        }
                        props.setProperty("VPFSpec." + key, value);
                        continue;
                    }
                    if (usealt && !altcov.equals("")) {
                        if (!key.startsWith("alt")) continue;
                        key = key.substring(3, key.length());
                        props.setProperty("VPFSpec." + key, value);
                        continue;
                    }
                    if (key.startsWith("alt")) continue;
                    props.setProperty("VPFSpec." + key, value);
                    continue;
                }
                int spacedelim = token.indexOf(" ");
                if (spacedelim == -1) {
                    cov.delete(0, cov.length());
                    cov = cov.append(token);
                    altcov = altcov.delete(0, altcov.length());
                    altcov.append("");
                    continue;
                }
                cov.delete(0, cov.length());
                cov = cov.append(token.substring(0, spacedelim));
                cov = altcov.delete(0, altcov.length());
                altcov = altcov.append(token.substring(spacedelim + 1, token.length()));
            }
        }
        catch (NoSuchElementException nee) {
            return props;
        }
    }

    public UGraphic[] fillRectangle(CProjection p, LLPoint ll1, LLPoint ll2, String staticArgs, StringHolder dynamicArgs, GraphicChange notifyOnChange, String uniqueID) {
        try {
            LatLonPoint.Double newll1 = new LatLonPoint.Double((double)ll1.lat, (double)ll1.lon);
            LatLonPoint.Double newll2 = new LatLonPoint.Double((double)ll2.lat, (double)ll2.lon);
            if (p.scale > 100000000 && MoreMath.approximately_equal((double)ll1.lon, (double)ll2.lon, (double)0.01)) {
                newll1.setLongitude(-180.0);
                newll2.setLongitude(180.0);
            }
            this.forgetComps(uniqueID);
            Debug.message((String)"vpfspecialist", (String)("fillRectangle.. " + staticArgs));
            Hashtable dynArgs = VPFSpecialist.parseDynamicArgs(dynamicArgs.value);
            VPFSpecialistGraphicWarehouse warehouse = new VPFSpecialistGraphicWarehouse();
            CheckButton[] buttons = null;
            SCheckBox s = (SCheckBox)this.checkboxes.get(uniqueID);
            if (s == null) {
                buttons = new CheckButton[3];
                Debug.message((String)"vpfspecialist", (String)"default buttons");
                buttons[0] = new CheckButton("Edges", false);
                buttons[1] = new CheckButton("Text", false);
                buttons[2] = new CheckButton("Area", false);
            } else {
                Debug.message((String)"vpfspecialist", (String)"palette buttons");
                buttons = s.buttons();
            }
            boolean showEdges = VPFSpecialist.getHashedValueAsBoolean(dynArgs, DynArgEdges) || buttons[0].checked;
            warehouse.setEdgeFeatures(showEdges);
            boolean showText = VPFSpecialist.getHashedValueAsBoolean(dynArgs, DynArgText) || buttons[1].checked;
            warehouse.setTextFeatures(showText);
            boolean showAreas = VPFSpecialist.getHashedValueAsBoolean(dynArgs, DynArgArea) || buttons[2].checked;
            warehouse.setAreaFeatures(showAreas);
            StringBuffer retcov = new StringBuffer();
            StringBuffer retaltcov = new StringBuffer("");
            boolean usealt = (float)p.scale >= 3.0E7f;
            Properties props = this.processTokens(staticArgs, retcov, retaltcov, usealt);
            if (Debug.debugging((String)"vpfspecialist")) {
                Debug.output((String)("VPFSpecialist: with prefix VPFSpec, properties: " + props));
            }
            warehouse.setProperties(prefix, props);
            String cov = retcov.toString().trim();
            String altcov = retaltcov.toString().trim();
            if (altcov.equals("")) {
                Debug.message((String)"vpfspecialist", (String)"Altcov = null");
                altcov = null;
            }
            this.lst.drawTile(p.scale, (int)p.width, (int)p.height, altcov != null && (float)p.scale >= 3.0E7f ? altcov : cov, (VPFGraphicWarehouse)warehouse, (LatLonPoint)newll1, (LatLonPoint)newll2);
            UGraphic[] retlist = warehouse.packGraphics();
            if (Debug.debugging((String)"vpfspecialist")) {
                Debug.output((String)("retlist.size(): " + retlist.length));
            }
            warehouse = null;
            Debug.message((String)"vpfspecialist", (String)"returning from fillRectangle");
            return retlist;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return new UGraphic[0];
        }
    }

    private synchronized void forgetComps(String uniqueID) {
        Comp[] oldcomps = (Comp[])this.comphash.remove(uniqueID);
        if (oldcomps != null) {
            Debug.message((String)"vpfspecialist", (String)"Releasing comps");
        }
    }

    public void receiveGesture(MouseEvent gesture, String uniqueID) {
    }

    public void makePalette(WidgetChange notifyOnChange, String staticArgs, StringHolder dynamicArgs, String uniqueID) {
        this.clearPalette();
        CheckButton[] buttons = new CheckButton[]{new CheckButton("Edges", false), new CheckButton("Text", false), new CheckButton("Area", false)};
        UsefulCheckbox cb = new UsefulCheckbox("Feature Types:", buttons);
        this.checkboxes.put(uniqueID, cb);
        this.addPalette(cb.widget());
    }

    public void parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-dcwpath") || args[i].equalsIgnoreCase("-datapath")) {
                this.dcwpath = args[++i];
            }
            if (!args[i].equalsIgnoreCase("-verbose")) continue;
            Debug.put((String)"vpfspecialist");
        }
        super.parseArgs(args);
        this.initDcwFiles();
    }

    public void initDcwFiles() {
        if (this.dcwpath == null) {
            this.dcwpath = "/usr/local/matt/data/dcw";
        }
        try {
            String[] paths = this.parsePaths(this.dcwpath);
            if (paths != null) {
                this.lst = new LibrarySelectionTable();
                for (int i = 0; i < paths.length; ++i) {
                    System.out.println("VPFSpecialist: adding " + paths[i] + " to server");
                    this.lst.addDataPath(paths[i]);
                }
            }
        }
        catch (FormatException f) {
            throw new IllegalArgumentException(f.getMessage());
        }
    }

    public String[] parsePaths(String path) {
        String[] ret = null;
        String tok = ";";
        if (path != null) {
            if (Debug.debugging((String)"vpfspecialist")) {
                System.out.println("VPFSpecialist: parsing path string: " + path);
            }
            try {
                StringTokenizer token = new StringTokenizer(path, tok);
                int numPaths = token.countTokens();
                ret = new String[numPaths];
                for (int i = 0; i < numPaths; ++i) {
                    ret[i] = token.nextToken();
                }
                return ret;
            }
            catch (NoSuchElementException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public void printHelp() {
        System.err.println("usage: java <specialist> -ior <file> -datapath <path1;path2;path3>");
    }

    public void signOff(String uniqueID) {
        this.forgetComps(uniqueID);
        if (Debug.debugging((String)"vpfspecialist")) {
            Debug.output((String)("Client |" + uniqueID + "| going away..."));
        }
    }

    public static HttpServer startHttpServer(int port) {
        try {
            HttpServer server = new HttpServer(port, true);
            server.addHttpRequestListener((HttpRequestListener)new TableListener());
            return server;
        }
        catch (IOException e) {
            Debug.output((String)"Unable to start http server:");
            return null;
        }
    }

    public static Hashtable parseDynamicArgs(String args) {
        Hashtable<String, Boolean> dynArgs = new Hashtable<String, Boolean>();
        if (args != null) {
            String lowerArgs = args.toLowerCase();
            dynArgs.put(DynArgEdges, new Boolean(lowerArgs.indexOf(DynArgEdges) != -1));
            dynArgs.put(DynArgText, new Boolean(lowerArgs.indexOf(DynArgText) != -1));
            dynArgs.put(DynArgArea, new Boolean(lowerArgs.indexOf(DynArgArea) != -1));
        }
        return dynArgs;
    }

    public static boolean getHashedValueAsBoolean(Hashtable dynArgs, String arg) {
        Object obj = dynArgs.get(arg);
        if (obj == null) {
            return false;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return false;
    }

    public static void main(String[] args) {
        Debug.init((Properties)System.getProperties());
        Debug.message((String)"vpfspecialist", (String)"VPFSpecialist starting up");
        int port = 0;
        VPFSpecialist.startHttpServer(port);
        VPFSpecialist srv = new VPFSpecialist("VPFSpecialist");
        srv.start(args);
    }
}

