/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.plugin.corbaImage;

import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.image.ImageServerConstants;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.plugin.WebImagePlugIn;
import com.bbn.openmap.plugin.corbaImage.corbaImageServer.Server;
import com.bbn.openmap.plugin.corbaImage.corbaImageServer.ServerHelper;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import com.bbn.openmap.util.corba.CORBASupport;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.swing.ImageIcon;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;

public class CorbaImagePlugIn
extends WebImagePlugIn
implements ImageServerConstants {
    protected String queryHeader = null;
    protected String imageFormat = null;
    protected String backgroundColor = null;
    protected boolean transparent = false;
    public static final String ImageFormatProperty = "format";
    public static final String BackgroundColorProperty = "backgroundColor";
    public static final String TransparentProperty = "transparent";
    public static final String iorUrlProperty = "ior";
    public static final String namingProperty = "name";
    protected transient Server server = null;
    protected URL iorURL = null;
    protected String naming = null;

    public String createQueryString(Projection p) {
        String layers;
        if (this.queryHeader == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(this.queryHeader);
        buf.append("REQUEST=map&");
        if (p != null) {
            Point2D center = p.getCenter();
            buf.append("PROJTYPE=" + p.getName() + "&" + "SCALE" + "=" + p.getScale() + "&" + "LAT" + "=" + center.getY() + "&" + "LON" + "=" + center.getX() + "&" + "HEIGHT" + "=" + p.getHeight() + "&" + "WIDTH" + "=" + p.getWidth());
        } else {
            buf.append("PROJTYPE=name_undefined&SCALE=scale_undefined&LAT=center_lat_undefined&LON=center_lon_undefined&HEIGHT=height_undefined&WIDTH=width_undefined");
        }
        if (this.imageFormat != null) {
            buf.append("&FORMAT=" + this.imageFormat);
        }
        if (this.transparent) {
            buf.append("&TRANSPARENT=true");
        }
        if (this.backgroundColor != null) {
            buf.append("&BGCOLOR=" + this.backgroundColor);
        }
        if ((layers = this.getLayerMarkers()) != null) {
            buf.append("&" + layers);
        }
        return buf.toString();
    }

    public String getServerName() {
        return this.queryHeader;
    }

    public String getLayerMarkers() {
        return null;
    }

    public OMGraphicList getRectangle(Projection p) {
        OMGraphicList list = new OMGraphicList();
        this.currentProjection = p;
        String urlString = this.createQueryString(p);
        if (Debug.debugging((String)"cis")) {
            Debug.output((String)("CorbaImagePlugIn.getRectangle() with \"" + urlString + "\""));
        }
        if (urlString == null) {
            return list;
        }
        Server serv = this.getServer();
        if (serv == null) {
            return null;
        }
        Debug.message((String)"cis", (String)"CorbaImagePlugIn: requesting image data from server...");
        try {
            byte[] imageData = serv.getImage(urlString);
            if (Debug.debugging((String)"cis")) {
                Debug.output((String)("CorbaImagePlugIn: got image data length " + imageData.length));
            }
            ImageIcon ii = new ImageIcon(imageData);
            OMRaster image = new OMRaster(0, 0, ii);
            list.add((OMGraphic)image);
        }
        catch (SystemException e) {
            this.handleCORBAError(e);
            this.server = null;
        }
        list.generate(p);
        return list;
    }

    public void setProperties(String prefix, Properties setList) {
        super.setProperties(prefix, setList);
        prefix = PropUtils.getScopedPropertyPrefix((String)prefix);
        this.imageFormat = setList.getProperty(prefix + ImageFormatProperty);
        this.transparent = PropUtils.booleanFromProperties((Properties)setList, (String)(prefix + TransparentProperty), (boolean)false);
        this.backgroundColor = setList.getProperty(prefix + BackgroundColorProperty);
        String url = setList.getProperty(prefix + iorUrlProperty);
        if (url != null) {
            try {
                this.iorURL = PropUtils.getResourceOrFileOrURL((String)url);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("\"" + url + "\"" + " is malformed.");
            }
        }
        this.naming = setList.getProperty(prefix + namingProperty);
        Debug.message((String)"cis", (String)("CorbaImagePlugIn.setProperties(): naming = " + this.naming));
        this.queryHeader = "";
        if (Debug.debugging((String)"plugin")) {
            Debug.output((String)("CorbaImagePlugIn: set up with header \"" + this.queryHeader + "\""));
        }
    }

    public Properties getProperties(Properties getList) {
        getList = super.getProperties(getList);
        String prefix = PropUtils.getScopedPropertyPrefix((PropertyConsumer)this);
        String iorString = null;
        if (this.iorURL != null) {
            iorString = this.iorURL.toString();
        }
        getList.put(prefix + iorUrlProperty, PropUtils.unnull((String)iorString));
        getList.put(prefix + namingProperty, PropUtils.unnull((String)this.naming));
        getList.put(prefix + ImageFormatProperty, PropUtils.unnull((String)this.imageFormat));
        getList.put(prefix + TransparentProperty, new Boolean(this.transparent).toString());
        getList.put(prefix + BackgroundColorProperty, PropUtils.unnull((String)this.backgroundColor));
        return getList;
    }

    public Properties getPropertyInfo(Properties list) {
        list = super.getPropertyInfo(list);
        list.put(iorUrlProperty, "The URL of the ior file for the server.");
        list.put(namingProperty, "The Naming Services Name of the server.");
        list.put(ImageFormatProperty, "Image format (JPEG|GIF|PPM|PNG)");
        list.put(TransparentProperty, "Whether the background should be transparent");
        list.put("transparent.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        list.put(BackgroundColorProperty, "Background color for image.");
        list.put("backgroundColor.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        return list;
    }

    public void setNaming(String CORBAName) {
        this.naming = CORBAName;
    }

    public String getNaming() {
        return this.naming;
    }

    public void setIorURL(URL iorurl) {
        this.iorURL = iorurl;
    }

    public URL getIorURL() {
        return this.iorURL;
    }

    public Server getServer() {
        if (this.server == null) {
            this.initServer();
        }
        return this.server;
    }

    private void initServer() {
        String ior = null;
        Object object = null;
        CORBASupport cs = new CORBASupport();
        try {
            object = cs.readIOR(this.iorURL);
            this.server = ServerHelper.narrow(object);
        }
        catch (IOException ioe) {
            if (Debug.debugging((String)"cis")) {
                Debug.output((String)(this.getName() + "(CIS).initServer() IO Exception with ior: " + this.iorURL));
            }
            this.server = null;
            return;
        }
        if (this.server == null && (object = cs.resolveName(this.naming)) != null) {
            this.server = ServerHelper.narrow(object);
            if (Debug.debugging((String)"cis")) {
                Debug.output((String)"Have a CorbaImageServer:");
                Debug.output((String)("*** Server: is a " + this.server.getClass().getName() + "\n" + this.server));
            }
        }
        if (Debug.debugging((String)"cis")) {
            if (this.server == null) {
                Debug.error((String)("CIS.initServer: null server!\n  IOR=" + ior + "\n  Name = " + this.naming));
            } else {
                Debug.output((String)"CIS: server is golden.");
            }
        }
    }

    protected void handleCORBAError(SystemException e) {
        if (e.toString().indexOf("InterruptedIOException") != -1) {
            Debug.error((String)"CorbaImagePlugIn server communication interrupted!");
        } else {
            Debug.error((String)("CorbaImagePlugIn caught CORBA exception: " + (java.lang.Object)((java.lang.Object)e) + "\n" + "CorbaImagePlugIn Exception class: " + ((java.lang.Object)((java.lang.Object)e)).getClass().getName() + "\nSpecific Message: " + e.getMessage()));
            e.printStackTrace();
        }
        this.server = null;
    }
}

