/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.inject;

import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.util.ArrayList;
import java.util.HashSet;
import org.sonatype.guice.bean.inject.BeanBinder;
import org.sonatype.guice.bean.inject.BeanInjector;
import org.sonatype.guice.bean.inject.PropertyBinder;
import org.sonatype.guice.bean.inject.PropertyBinding;
import org.sonatype.guice.bean.reflect.BeanProperties;
import org.sonatype.guice.bean.reflect.BeanProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeanListener
implements TypeListener {
    private final BeanBinder beanBinder;

    public BeanListener(BeanBinder beanBinder) {
        this.beanBinder = beanBinder;
    }

    public <B> void hear(TypeLiteral<B> type, TypeEncounter<B> encounter) {
        PropertyBinder propertyBinder = this.beanBinder.bindBean(type, encounter);
        if (null == propertyBinder) {
            return;
        }
        ArrayList<PropertyBinding> bindings = new ArrayList<PropertyBinding>();
        HashSet<String> visited = new HashSet<String>();
        for (BeanProperty property : new BeanProperties(type.getRawType())) {
            String name = property.getName();
            if (!visited.add(name)) continue;
            try {
                PropertyBinding binding = propertyBinder.bindProperty(property);
                if (binding == PropertyBinder.LAST_BINDING) break;
                if (binding == null) continue;
                bindings.add(binding);
            }
            catch (Throwable e) {
                encounter.addError((Throwable)new ProvisionException("Error binding: " + property, e));
            }
        }
        if (bindings.size() > 0) {
            encounter.register(new BeanInjector(bindings));
        }
    }

    public static boolean isInjecting() {
        return BeanInjector.isInjecting();
    }
}

