/*
 * Decompiled with CFR 0.152.
 */
package org.opencarto.algo.centroid;

import com.vividsolutions.jts.algorithm.CentroidArea;
import com.vividsolutions.jts.algorithm.CentroidLine;
import com.vividsolutions.jts.algorithm.CentroidPoint;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;

public class Centroid {
    public static Point get(Geometry geom) {
        if (geom.isEmpty()) {
            return null;
        }
        Coordinate centPt = null;
        int dim = geom.getDimension();
        if (dim == 0) {
            CentroidPoint cent = new CentroidPoint();
            cent.add(geom);
            centPt = cent.getCentroid();
        } else if (dim == 1) {
            CentroidLine cent = new CentroidLine();
            cent.add(geom);
            centPt = cent.getCentroid();
        } else {
            CentroidArea cent = new CentroidArea();
            cent.add(geom);
            centPt = cent.getCentroid();
        }
        return geom.createPointFromInternalCoord(centPt, geom);
    }
}

