/*
 * Decompiled with CFR 0.152.
 */
package org.opencarto.algo;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.logging.Logger;

public class Rotation {
    private static Logger logger = Logger.getLogger(Rotation.class.getName());

    public static Coordinate get(Coordinate c, Coordinate center, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x = c.x;
        double y = c.y;
        double xc = center.x;
        double yc = center.y;
        return new Coordinate(xc + cos * (x - xc) - sin * (y - yc), yc + sin * (x - xc) + cos * (y - yc));
    }

    public static Coordinate[] get(Coordinate[] coord, Coordinate center, double angle) {
        Coordinate[] coord_ = new Coordinate[coord.length];
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double xc = center.x;
        double yc = center.y;
        for (int i = 0; i < coord.length; ++i) {
            Coordinate ci = coord[i];
            double x = ci.x;
            double y = ci.y;
            coord_[i] = new Coordinate(xc + cos * (x - xc) - sin * (y - yc), yc + sin * (x - xc) + cos * (y - yc));
        }
        return coord_;
    }

    public static Point get(Point geom, Coordinate center, double angle, GeometryFactory gf) {
        return gf.createPoint(Rotation.get(geom.getCoordinate(), center, angle));
    }

    public static LineString get(LineString ls, Coordinate center, double angle, GeometryFactory gf) {
        return gf.createLineString(Rotation.get(ls.getCoordinates(), center, angle));
    }

    public static LinearRing get(LinearRing lr, Coordinate center, double angle, GeometryFactory gf) {
        return gf.createLinearRing(Rotation.get(lr.getCoordinates(), center, angle));
    }

    public static Polygon get(Polygon geom, Coordinate c, double angle, GeometryFactory gf) {
        LinearRing lr = Rotation.get((LinearRing)geom.getExteriorRing(), c, angle, gf);
        LinearRing[] lr_ = new LinearRing[geom.getNumInteriorRing()];
        for (int j = 0; j < geom.getNumInteriorRing(); ++j) {
            lr_[j] = Rotation.get((LinearRing)geom.getInteriorRingN(j), c, angle, gf);
        }
        return gf.createPolygon(lr, lr_);
    }

    public static GeometryCollection get(GeometryCollection geomCol, Coordinate center, double angle, GeometryFactory gf) {
        Geometry[] gs = new Geometry[geomCol.getNumGeometries()];
        for (int i = 0; i < geomCol.getNumGeometries(); ++i) {
            gs[i] = Rotation.get(geomCol.getGeometryN(i), center, angle, gf);
        }
        return gf.createGeometryCollection(gs);
    }

    public static Geometry get(Geometry geom, Coordinate center, double angle, GeometryFactory gf) {
        if (geom instanceof Point) {
            return Rotation.get((Point)geom, center, angle, gf);
        }
        if (geom instanceof Polygon) {
            return Rotation.get((Polygon)geom, center, angle, gf);
        }
        if (geom instanceof LineString) {
            return Rotation.get((LineString)geom, center, angle, gf);
        }
        if (geom instanceof LinearRing) {
            return Rotation.get((LinearRing)geom, center, angle, gf);
        }
        logger.warning("Rotation of " + geom.getClass().getSimpleName() + " not supported yet.");
        return null;
    }
}

