/*
 * Decompiled with CFR 0.152.
 */
package org.opencarto.algo;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.logging.Logger;

public class Scaling {
    private static Logger logger = Logger.getLogger(Scaling.class.getName());

    public static Coordinate[] get(Coordinate[] coord, Coordinate c, double coef) {
        Coordinate[] coord_ = new Coordinate[coord.length];
        double xc = c.x;
        double yc = c.y;
        for (int i = 0; i < coord.length; ++i) {
            Coordinate ci = coord[i];
            double x = ci.x;
            double y = ci.y;
            coord_[i] = new Coordinate(xc + coef * (x - xc), yc + coef * (y - yc));
        }
        return coord_;
    }

    public static Point get(Point geom, Coordinate c, double coef, GeometryFactory gf) {
        double xc = c.x;
        double yc = c.y;
        return gf.createPoint(new Coordinate(xc + coef * (geom.getX() - xc), yc + coef * (geom.getY() - yc)));
    }

    public static LineString get(LineString ls, Coordinate c, double coef, GeometryFactory gf) {
        return gf.createLineString(Scaling.get(ls.getCoordinates(), c, coef));
    }

    public static LinearRing get(LinearRing lr, Coordinate c, double coef, GeometryFactory gf) {
        return gf.createLinearRing(Scaling.get(lr.getCoordinates(), c, coef));
    }

    public static Polygon get(Polygon geom, Coordinate c, double coef, GeometryFactory gf) {
        LinearRing lr = Scaling.get((LinearRing)geom.getExteriorRing(), c, coef, gf);
        LinearRing[] lr_ = new LinearRing[geom.getNumInteriorRing()];
        for (int j = 0; j < geom.getNumInteriorRing(); ++j) {
            lr_[j] = Scaling.get((LinearRing)geom.getInteriorRingN(j), c, coef, gf);
        }
        return gf.createPolygon(lr, lr_);
    }

    public static GeometryCollection get(GeometryCollection geomCol, Coordinate c, double coef, GeometryFactory gf) {
        Geometry[] gs = new Geometry[geomCol.getNumGeometries()];
        for (int i = 0; i < geomCol.getNumGeometries(); ++i) {
            gs[i] = Scaling.get(geomCol.getGeometryN(i), c, coef, gf);
        }
        return gf.createGeometryCollection(gs);
    }

    public static Geometry get(Geometry geom, Coordinate c, double coef, GeometryFactory gf) {
        if (geom instanceof Point) {
            return Scaling.get((Point)geom, c, coef, gf);
        }
        if (geom instanceof Polygon) {
            return Scaling.get((Polygon)geom, c, coef, gf);
        }
        if (geom instanceof LineString) {
            return Scaling.get((LineString)geom, c, coef, gf);
        }
        if (geom instanceof LinearRing) {
            return Scaling.get((LinearRing)geom, c, coef, gf);
        }
        logger.warning("Scaling of " + geom.getClass().getSimpleName() + " not supported yet.");
        return null;
    }
}

