/*
 * Decompiled with CFR 0.152.
 */
package org.opencarto.algo;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.logging.Logger;
import org.opencarto.algo.Rotation;

public class Stretching {
    private static Logger logger = Logger.getLogger(Stretching.class.getName());

    public static Point get(Point geom, Coordinate c, double angle, double k, GeometryFactory gf) {
        double a = angle + 1.5707963267948966;
        Coordinate c2 = Rotation.get(geom.getCoordinate(), c, -1.0 * a);
        double xc = c.x;
        double x = c2.x;
        Coordinate c3 = new Coordinate(xc + k * (x - xc), c2.y);
        return Rotation.get(gf.createPoint(c3), c, a, gf);
    }

    public static Polygon get(Polygon geom, Coordinate c, double angle, double k, GeometryFactory gf) {
        LinearRing lr = Stretching.get((LinearRing)geom.getExteriorRing(), c, angle, k, gf);
        LinearRing[] holes = new LinearRing[geom.getNumInteriorRing()];
        for (int j = 0; j < geom.getNumInteriorRing(); ++j) {
            holes[j] = Stretching.get((LinearRing)geom.getInteriorRingN(j), c, angle, k, gf);
        }
        return gf.createPolygon(lr, holes);
    }

    public static LinearRing get(LinearRing lr, Coordinate c, double angle, double k, GeometryFactory gf) {
        return gf.createLinearRing(Stretching.get(lr.getCoordinates(), c, angle, k));
    }

    public static LineString get(LineString ls, Coordinate c, double angle, double k, GeometryFactory gf) {
        return gf.createLineString(Stretching.get(ls.getCoordinates(), c, angle, k));
    }

    public static Coordinate[] get(Coordinate[] coord, Coordinate c, double angle, double coef) {
        double a = angle + 1.5707963267948966;
        Coordinate[] coord2 = Rotation.get(coord, c, -1.0 * a);
        Coordinate[] coord_ = new Coordinate[coord2.length];
        double xc = c.x;
        for (int i = 0; i < coord2.length; ++i) {
            Coordinate ci = coord2[i];
            double x = ci.x;
            coord_[i] = new Coordinate(xc + coef * (x - xc), ci.y);
        }
        return Rotation.get(coord_, c, a);
    }

    public static GeometryCollection get(GeometryCollection geomCol, Coordinate c, double angle, double k, GeometryFactory gf) {
        Geometry[] geoms = new Geometry[geomCol.getNumGeometries()];
        for (int i = 0; i < geomCol.getNumGeometries(); ++i) {
            geoms[i] = Stretching.get(geomCol.getGeometryN(i), c, angle, k, gf);
        }
        return gf.createGeometryCollection(geoms);
    }

    public static Geometry get(Geometry geom, Coordinate c, double angle, double k, GeometryFactory gf) {
        if (geom instanceof Point) {
            return Stretching.get((Point)geom, c, angle, k, gf);
        }
        if (geom instanceof Polygon) {
            return Stretching.get((Polygon)geom, c, angle, k, gf);
        }
        if (geom instanceof LineString) {
            return Stretching.get((LineString)geom, c, angle, k, gf);
        }
        if (geom instanceof LinearRing) {
            return Stretching.get((LinearRing)geom, c, angle, k, gf);
        }
        logger.warning("Stretching of " + geom.getClass().getSimpleName() + " not supported yet.");
        return null;
    }
}

