/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.util.Assert;
import java.io.Serializable;
import java.util.Comparator;

public class Coordinate
implements Comparable<Coordinate>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 6683108902428366910L;
    public static final double NULL_ORDINATE = Double.NaN;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    public double x;
    public double y;
    public double z;

    public Coordinate(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Coordinate() {
        this(0.0, 0.0);
    }

    public Coordinate(Coordinate c) {
        this(c.x, c.y, c.z);
    }

    public Coordinate(double x, double y) {
        this(x, y, Double.NaN);
    }

    public void setCoordinate(Coordinate other) {
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
    }

    public double getOrdinate(int ordinateIndex) {
        switch (ordinateIndex) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IllegalArgumentException("Invalid ordinate index: " + ordinateIndex);
    }

    public void setOrdinate(int ordinateIndex, double value) {
        switch (ordinateIndex) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.z = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid ordinate index: " + ordinateIndex);
            }
        }
    }

    public boolean equals2D(Coordinate other) {
        if (this.x != other.x) {
            return false;
        }
        return this.y == other.y;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Coordinate)) {
            return false;
        }
        return this.equals2D((Coordinate)other);
    }

    @Override
    public int compareTo(Coordinate other) {
        if (this.x < other.x) {
            return -1;
        }
        if (this.x > other.x) {
            return 1;
        }
        if (this.y < other.y) {
            return -1;
        }
        if (this.y > other.y) {
            return 1;
        }
        return 0;
    }

    public boolean equals3D(Coordinate other) {
        return this.x == other.x && this.y == other.y && (this.z == other.z || Double.isNaN(this.z) && Double.isNaN(other.z));
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public Object clone() {
        try {
            Coordinate coord = (Coordinate)super.clone();
            return coord;
        }
        catch (CloneNotSupportedException e) {
            Assert.shouldNeverReachHere("this shouldn't happen because this class is Cloneable");
            return null;
        }
    }

    public double distance(Coordinate p) {
        double dx = this.x - p.x;
        double dy = this.y - p.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + Coordinate.hashCode(this.x);
        result = 37 * result + Coordinate.hashCode(this.y);
        return result;
    }

    public static int hashCode(double x) {
        long f = Double.doubleToLongBits(x);
        return (int)(f ^ f >>> 32);
    }

    public static class DimensionalComparator
    implements Comparator<Coordinate> {
        private int dimensionsToTest = 2;

        public static int compare(double a, double b) {
            if (a < b) {
                return -1;
            }
            if (a > b) {
                return 1;
            }
            if (Double.isNaN(a)) {
                if (Double.isNaN(b)) {
                    return 0;
                }
                return -1;
            }
            if (Double.isNaN(b)) {
                return 1;
            }
            return 0;
        }

        public DimensionalComparator() {
            this(2);
        }

        public DimensionalComparator(int dimensionsToTest) {
            if (dimensionsToTest != 2 && dimensionsToTest != 3) {
                throw new IllegalArgumentException("only 2 or 3 dimensions may be specified");
            }
            this.dimensionsToTest = dimensionsToTest;
        }

        @Override
        public int compare(Coordinate c1, Coordinate c2) {
            int compX = DimensionalComparator.compare(c1.x, c2.x);
            if (compX != 0) {
                return compX;
            }
            int compY = DimensionalComparator.compare(c1.y, c2.y);
            if (compY != 0) {
                return compY;
            }
            if (this.dimensionsToTest <= 2) {
                return 0;
            }
            int compZ = DimensionalComparator.compare(c1.z, c2.z);
            return compZ;
        }
    }
}

