/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateSequenceComparator;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.util.Assert;
import com.vividsolutions.jts.geom.util.WKTWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

public abstract class Geometry
implements Cloneable,
Comparable<Geometry>,
Serializable {
    private static final long serialVersionUID = 8763622679187376702L;
    private static Class<?>[] sortedClasses;
    private static final GeometryComponentFilter geometryChangedFilter;
    protected Envelope envelope;
    protected final GeometryFactory factory;
    protected int SRID;
    private Object userData = null;

    public Geometry(GeometryFactory factory) {
        this.factory = factory;
        this.SRID = factory.getSRID();
    }

    public abstract String getGeometryType();

    protected static boolean hasNonEmptyElements(Geometry[] geometries) {
        for (int i = 0; i < geometries.length; ++i) {
            if (geometries[i].isEmpty()) continue;
            return true;
        }
        return false;
    }

    protected static boolean hasNullElements(Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null) continue;
            return true;
        }
        return false;
    }

    public int getSRID() {
        return this.SRID;
    }

    public void setSRID(int SRID) {
        this.SRID = SRID;
    }

    public GeometryFactory getFactory() {
        return this.factory;
    }

    public Object getUserData() {
        return this.userData;
    }

    public int getNumGeometries() {
        return 1;
    }

    public abstract Geometry getGeometryN(int var1);

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public PrecisionModel getPrecisionModel() {
        return this.factory.getPrecisionModel();
    }

    public abstract Coordinate getCoordinate();

    public abstract Coordinate[] getCoordinates();

    public abstract int getNumPoints();

    public abstract boolean isEmpty();

    public boolean isRectangle() {
        return false;
    }

    public double getArea() {
        return 0.0;
    }

    public double getLength() {
        return 0.0;
    }

    public abstract int getDimension();

    public abstract int getBoundaryDimension();

    public Geometry getEnvelope() {
        return this.getFactory().toGeometry(this.getEnvelopeInternal());
    }

    public Envelope getEnvelopeInternal() {
        if (this.envelope == null) {
            this.envelope = this.computeEnvelopeInternal();
        }
        return this.envelope;
    }

    public void geometryChanged() {
        this.apply(geometryChangedFilter);
    }

    protected void geometryChangedAction() {
        this.envelope = null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Geometry)) {
            return false;
        }
        Geometry g = (Geometry)o;
        return this.equalsExact(g);
    }

    public int hashCode() {
        return this.getEnvelopeInternal().hashCode();
    }

    public String toString() {
        return this.toText();
    }

    public String toText() {
        WKTWriter writer = new WKTWriter();
        return writer.write(this);
    }

    public abstract Geometry reverse();

    public abstract boolean equalsExact(Geometry var1, double var2);

    public boolean equalsExact(Geometry other) {
        return this.equalsExact(other, 0.0);
    }

    public boolean equalsNorm(Geometry g) {
        if (g == null) {
            return false;
        }
        return this.norm().equalsExact(g.norm());
    }

    public abstract void apply(CoordinateFilter var1);

    public abstract void apply(CoordinateSequenceFilter var1);

    public abstract void apply(GeometryFilter var1);

    public abstract void apply(GeometryComponentFilter var1);

    public Object clone() {
        try {
            Geometry clone = (Geometry)super.clone();
            if (clone.envelope != null) {
                clone.envelope = new Envelope(clone.envelope);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            Assert.shouldNeverReachHere();
            return null;
        }
    }

    public abstract void normalize();

    public Geometry norm() {
        Geometry copy = (Geometry)this.clone();
        copy.normalize();
        return copy;
    }

    @Override
    public int compareTo(Geometry other) {
        if (this.getClassSortIndex() != other.getClassSortIndex()) {
            return this.getClassSortIndex() - other.getClassSortIndex();
        }
        if (this.isEmpty() && other.isEmpty()) {
            return 0;
        }
        if (this.isEmpty()) {
            return -1;
        }
        if (other.isEmpty()) {
            return 1;
        }
        return this.compareToSameClass(other);
    }

    public int compareTo(Geometry other, CoordinateSequenceComparator comp) {
        if (this.getClassSortIndex() != other.getClassSortIndex()) {
            return this.getClassSortIndex() - other.getClassSortIndex();
        }
        if (this.isEmpty() && other.isEmpty()) {
            return 0;
        }
        if (this.isEmpty()) {
            return -1;
        }
        if (other.isEmpty()) {
            return 1;
        }
        return this.compareToSameClass(other, comp);
    }

    protected boolean isEquivalentClass(Geometry other) {
        return this.getClass().getName().equals(other.getClass().getName());
    }

    public void checkNotGeometryCollection() {
        if (this.isGeometryCollection()) {
            throw new IllegalArgumentException("This method does not support GeometryCollection arguments");
        }
    }

    public boolean isGeometryCollection() {
        return this.getClass().equals(GeometryCollection.class);
    }

    protected abstract Envelope computeEnvelopeInternal();

    protected abstract int compareToSameClass(Object var1);

    protected abstract int compareToSameClass(Object var1, CoordinateSequenceComparator var2);

    protected int compare(Collection<Geometry> a, Collection<Geometry> b) {
        Iterator<Geometry> i = a.iterator();
        Iterator<Geometry> j = b.iterator();
        while (i.hasNext() && j.hasNext()) {
            Geometry bElement;
            Geometry aElement = i.next();
            int comparison = aElement.compareTo(bElement = j.next());
            if (comparison == 0) continue;
            return comparison;
        }
        if (i.hasNext()) {
            return 1;
        }
        if (j.hasNext()) {
            return -1;
        }
        return 0;
    }

    protected boolean equal(Coordinate a, Coordinate b, double tolerance) {
        if (tolerance == 0.0) {
            return a.equals(b);
        }
        return a.distance(b) <= tolerance;
    }

    private int getClassSortIndex() {
        if (sortedClasses == null) {
            Geometry.initSortedClasses();
        }
        for (int i = 0; i < sortedClasses.length; ++i) {
            if (!sortedClasses[i].isInstance(this)) continue;
            return i;
        }
        Assert.shouldNeverReachHere("Class not supported: " + this.getClass());
        return -1;
    }

    private static void initSortedClasses() {
        sortedClasses = new Class[]{Point.class, MultiPoint.class, LineString.class, LinearRing.class, MultiLineString.class, Polygon.class, MultiPolygon.class, GeometryCollection.class};
    }

    public Point createPointFromInternalCoord(Coordinate coord, Geometry exemplar) {
        exemplar.getPrecisionModel().makePrecise(coord);
        return exemplar.getFactory().createPoint(coord);
    }

    static {
        geometryChangedFilter = new GeometryComponentFilter(){

            @Override
            public void filter(Geometry geom) {
                geom.geometryChangedAction();
            }
        };
    }
}

