/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateSequenceComparator;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jts.geom.util.Assert;
import java.util.Arrays;
import java.util.TreeSet;

public class GeometryCollection
extends Geometry {
    private static final long serialVersionUID = -5694727726395021467L;
    protected Geometry[] geometries;

    public GeometryCollection(Geometry[] geometries, GeometryFactory factory) {
        super(factory);
        this.geometries = geometries;
        if (this.geometries == null) {
            this.geometries = new Geometry[0];
        }
        if (GeometryCollection.hasNullElements(this.geometries)) {
            throw new IllegalArgumentException("geometries must not contain null elements");
        }
    }

    @Override
    public Coordinate getCoordinate() {
        if (this.isEmpty()) {
            return null;
        }
        return this.geometries[0].getCoordinate();
    }

    @Override
    public Coordinate[] getCoordinates() {
        Coordinate[] coordinates = new Coordinate[this.getNumPoints()];
        int k = -1;
        for (int i = 0; i < this.geometries.length; ++i) {
            Coordinate[] childCoordinates = this.geometries[i].getCoordinates();
            for (int j = 0; j < childCoordinates.length; ++j) {
                coordinates[++k] = childCoordinates[j];
            }
        }
        return coordinates;
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < this.geometries.length; ++i) {
            if (this.geometries[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getDimension() {
        int dimension = -1;
        for (int i = 0; i < this.geometries.length; ++i) {
            dimension = Math.max(dimension, this.geometries[i].getDimension());
        }
        return dimension;
    }

    @Override
    public int getBoundaryDimension() {
        int dimension = -1;
        for (int i = 0; i < this.geometries.length; ++i) {
            dimension = Math.max(dimension, this.geometries[i].getBoundaryDimension());
        }
        return dimension;
    }

    @Override
    public int getNumGeometries() {
        return this.geometries.length;
    }

    @Override
    public Geometry getGeometryN(int n) {
        return this.geometries[n];
    }

    @Override
    public int getNumPoints() {
        int numPoints = 0;
        for (int i = 0; i < this.geometries.length; ++i) {
            numPoints += this.geometries[i].getNumPoints();
        }
        return numPoints;
    }

    @Override
    public String getGeometryType() {
        return "GeometryCollection";
    }

    public Geometry getBoundary() {
        this.checkNotGeometryCollection();
        Assert.shouldNeverReachHere();
        return null;
    }

    @Override
    public double getArea() {
        double area = 0.0;
        for (int i = 0; i < this.geometries.length; ++i) {
            area += this.geometries[i].getArea();
        }
        return area;
    }

    @Override
    public double getLength() {
        double sum = 0.0;
        for (int i = 0; i < this.geometries.length; ++i) {
            sum += this.geometries[i].getLength();
        }
        return sum;
    }

    @Override
    public boolean equalsExact(Geometry other, double tolerance) {
        if (!this.isEquivalentClass(other)) {
            return false;
        }
        GeometryCollection otherCollection = (GeometryCollection)other;
        if (this.geometries.length != otherCollection.geometries.length) {
            return false;
        }
        for (int i = 0; i < this.geometries.length; ++i) {
            if (this.geometries[i].equalsExact(otherCollection.geometries[i], tolerance)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void apply(CoordinateFilter filter) {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].apply(filter);
        }
    }

    @Override
    public void apply(CoordinateSequenceFilter filter) {
        if (this.geometries.length == 0) {
            return;
        }
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].apply(filter);
            if (filter.isDone()) break;
        }
        if (filter.isGeometryChanged()) {
            this.geometryChanged();
        }
    }

    @Override
    public void apply(GeometryFilter filter) {
        filter.filter(this);
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].apply(filter);
        }
    }

    @Override
    public void apply(GeometryComponentFilter filter) {
        filter.filter(this);
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].apply(filter);
        }
    }

    @Override
    public Object clone() {
        GeometryCollection gc = (GeometryCollection)super.clone();
        gc.geometries = new Geometry[this.geometries.length];
        for (int i = 0; i < this.geometries.length; ++i) {
            gc.geometries[i] = (Geometry)this.geometries[i].clone();
        }
        return gc;
    }

    @Override
    public void normalize() {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].normalize();
        }
        Arrays.sort(this.geometries);
    }

    @Override
    protected Envelope computeEnvelopeInternal() {
        Envelope env = new Envelope();
        for (int i = 0; i < this.geometries.length; ++i) {
            env.expandToInclude(this.geometries[i].getEnvelopeInternal());
        }
        return env;
    }

    @Override
    protected int compareToSameClass(Object o) {
        TreeSet<Geometry> theseElements = new TreeSet<Geometry>(Arrays.asList(this.geometries));
        TreeSet<Geometry> otherElements = new TreeSet<Geometry>(Arrays.asList(((GeometryCollection)o).geometries));
        return this.compare(theseElements, otherElements);
    }

    @Override
    protected int compareToSameClass(Object o, CoordinateSequenceComparator comp) {
        int i;
        GeometryCollection gc = (GeometryCollection)o;
        int n1 = this.getNumGeometries();
        int n2 = gc.getNumGeometries();
        for (i = 0; i < n1 && i < n2; ++i) {
            Geometry otherGeom;
            Geometry thisGeom = this.getGeometryN(i);
            int holeComp = thisGeom.compareToSameClass(otherGeom = gc.getGeometryN(i), comp);
            if (holeComp == 0) continue;
            return holeComp;
        }
        if (i < n1) {
            return 1;
        }
        if (i < n2) {
            return -1;
        }
        return 0;
    }

    @Override
    public Geometry reverse() {
        int n = this.geometries.length;
        Geometry[] revGeoms = new Geometry[n];
        for (int i = 0; i < this.geometries.length; ++i) {
            revGeoms[i] = this.geometries[i].reverse();
        }
        return this.getFactory().createGeometryCollection(revGeoms);
    }
}

