/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.Polygonal;
import java.util.ArrayList;

public class MultiPolygon
extends GeometryCollection
implements Polygonal {
    private static final long serialVersionUID = -551033529766975875L;

    public MultiPolygon(Polygon[] polygons, GeometryFactory factory) {
        super(polygons, factory);
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public int getBoundaryDimension() {
        return 1;
    }

    @Override
    public String getGeometryType() {
        return "MultiPolygon";
    }

    public boolean isSimple() {
        return true;
    }

    @Override
    public Geometry getBoundary() {
        if (this.isEmpty()) {
            return this.getFactory().createMultiLineString(null);
        }
        ArrayList<LineString> allRings = new ArrayList<LineString>();
        for (int i = 0; i < this.geometries.length; ++i) {
            Polygon polygon = (Polygon)this.geometries[i];
            Geometry rings = polygon.getBoundary();
            for (int j = 0; j < rings.getNumGeometries(); ++j) {
                allRings.add((LineString)rings.getGeometryN(j));
            }
        }
        LineString[] allRingsArray = new LineString[allRings.size()];
        return this.getFactory().createMultiLineString(allRings.toArray(allRingsArray));
    }

    @Override
    public boolean equalsExact(Geometry other, double tolerance) {
        if (!this.isEquivalentClass(other)) {
            return false;
        }
        return super.equalsExact(other, tolerance);
    }

    @Override
    public Geometry reverse() {
        int n = this.geometries.length;
        Polygon[] revGeoms = new Polygon[n];
        for (int i = 0; i < this.geometries.length; ++i) {
            revGeoms[i] = (Polygon)this.geometries[i].reverse();
        }
        return this.getFactory().createMultiPolygon(revGeoms);
    }
}

