/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceComparator;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygonal;
import com.vividsolutions.jts.geom.util.CGAlgorithms;
import java.util.Arrays;

public class Polygon
extends Geometry
implements Polygonal {
    private static final long serialVersionUID = -3494792200821764533L;
    protected LinearRing shell = null;
    protected LinearRing[] holes;

    public Polygon(LinearRing shell, LinearRing[] holes, GeometryFactory factory) {
        super(factory);
        this.shell = shell;
        this.holes = holes;
        if (this.shell == null) {
            this.shell = this.getFactory().createLinearRing((CoordinateSequence)null);
        }
        if (this.holes == null) {
            this.holes = new LinearRing[0];
        }
        if (Polygon.hasNullElements(this.holes)) {
            throw new IllegalArgumentException("holes must not contain null elements");
        }
        if (this.shell.isEmpty() && Polygon.hasNonEmptyElements(this.holes)) {
            throw new IllegalArgumentException("shell is empty but holes are not");
        }
    }

    @Override
    public Coordinate getCoordinate() {
        return this.shell.getCoordinate();
    }

    @Override
    public Coordinate[] getCoordinates() {
        if (this.isEmpty()) {
            return new Coordinate[0];
        }
        Coordinate[] coordinates = new Coordinate[this.getNumPoints()];
        int k = -1;
        Coordinate[] shellCoordinates = this.shell.getCoordinates();
        for (int x = 0; x < shellCoordinates.length; ++x) {
            coordinates[++k] = shellCoordinates[x];
        }
        for (int i = 0; i < this.holes.length; ++i) {
            Coordinate[] childCoordinates = this.holes[i].getCoordinates();
            for (int j = 0; j < childCoordinates.length; ++j) {
                coordinates[++k] = childCoordinates[j];
            }
        }
        return coordinates;
    }

    @Override
    public int getNumPoints() {
        int numPoints = this.shell.getNumPoints();
        for (int i = 0; i < this.holes.length; ++i) {
            numPoints += this.holes[i].getNumPoints();
        }
        return numPoints;
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public int getBoundaryDimension() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return this.shell.isEmpty();
    }

    public boolean isSimple() {
        return true;
    }

    @Override
    public boolean isRectangle() {
        if (this.getNumInteriorRing() != 0) {
            return false;
        }
        if (this.shell == null) {
            return false;
        }
        if (this.shell.getNumPoints() != 5) {
            return false;
        }
        CoordinateSequence seq = this.shell.getCoordinateSequence();
        Envelope env = this.getEnvelopeInternal();
        for (int i = 0; i < 5; ++i) {
            double x = seq.getX(i);
            if (x != env.getMinX() && x != env.getMaxX()) {
                return false;
            }
            double y = seq.getY(i);
            if (y == env.getMinY() || y == env.getMaxY()) continue;
            return false;
        }
        double prevX = seq.getX(0);
        double prevY = seq.getY(0);
        for (int i = 1; i <= 4; ++i) {
            boolean yChanged;
            double x = seq.getX(i);
            double y = seq.getY(i);
            boolean xChanged = x != prevX;
            boolean bl = yChanged = y != prevY;
            if (xChanged == yChanged) {
                return false;
            }
            prevX = x;
            prevY = y;
        }
        return true;
    }

    public LineString getExteriorRing() {
        return this.shell;
    }

    public int getNumInteriorRing() {
        return this.holes.length;
    }

    public LineString getInteriorRingN(int n) {
        return this.holes[n];
    }

    @Override
    public String getGeometryType() {
        return "Polygon";
    }

    @Override
    public double getArea() {
        double area = 0.0;
        area += Math.abs(CGAlgorithms.signedArea(this.shell.getCoordinateSequence()));
        for (int i = 0; i < this.holes.length; ++i) {
            area -= Math.abs(CGAlgorithms.signedArea(this.holes[i].getCoordinateSequence()));
        }
        return area;
    }

    @Override
    public double getLength() {
        double len = 0.0;
        len += this.shell.getLength();
        for (int i = 0; i < this.holes.length; ++i) {
            len += this.holes[i].getLength();
        }
        return len;
    }

    public Geometry getBoundary() {
        if (this.isEmpty()) {
            return this.getFactory().createMultiLineString(null);
        }
        LineString[] rings = new LinearRing[this.holes.length + 1];
        rings[0] = this.shell;
        for (int i = 0; i < this.holes.length; ++i) {
            rings[i + 1] = this.holes[i];
        }
        if (rings.length <= 1) {
            return this.getFactory().createLinearRing(rings[0].getCoordinateSequence());
        }
        return this.getFactory().createMultiLineString(rings);
    }

    @Override
    protected Envelope computeEnvelopeInternal() {
        return this.shell.getEnvelopeInternal();
    }

    @Override
    public boolean equalsExact(Geometry other, double tolerance) {
        if (!this.isEquivalentClass(other)) {
            return false;
        }
        Polygon otherPolygon = (Polygon)other;
        LinearRing thisShell = this.shell;
        LinearRing otherPolygonShell = otherPolygon.shell;
        if (!((Geometry)thisShell).equalsExact(otherPolygonShell, tolerance)) {
            return false;
        }
        if (this.holes.length != otherPolygon.holes.length) {
            return false;
        }
        if (this.holes.length != otherPolygon.holes.length) {
            return false;
        }
        for (int i = 0; i < this.holes.length; ++i) {
            if (((Geometry)this.holes[i]).equalsExact(otherPolygon.holes[i], tolerance)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void apply(CoordinateFilter filter) {
        this.shell.apply(filter);
        for (int i = 0; i < this.holes.length; ++i) {
            this.holes[i].apply(filter);
        }
    }

    @Override
    public void apply(CoordinateSequenceFilter filter) {
        this.shell.apply(filter);
        if (!filter.isDone()) {
            for (int i = 0; i < this.holes.length; ++i) {
                this.holes[i].apply(filter);
                if (filter.isDone()) break;
            }
        }
        if (filter.isGeometryChanged()) {
            this.geometryChanged();
        }
    }

    @Override
    public void apply(GeometryFilter filter) {
        filter.filter(this);
    }

    @Override
    public void apply(GeometryComponentFilter filter) {
        filter.filter(this);
        this.shell.apply(filter);
        for (int i = 0; i < this.holes.length; ++i) {
            this.holes[i].apply(filter);
        }
    }

    @Override
    public Object clone() {
        Polygon poly = (Polygon)super.clone();
        poly.shell = (LinearRing)this.shell.clone();
        poly.holes = new LinearRing[this.holes.length];
        for (int i = 0; i < this.holes.length; ++i) {
            poly.holes[i] = (LinearRing)this.holes[i].clone();
        }
        return poly;
    }

    @Override
    public void normalize() {
        Polygon.normalize(this.shell, true);
        for (int i = 0; i < this.holes.length; ++i) {
            Polygon.normalize(this.holes[i], false);
        }
        Arrays.sort(this.holes);
    }

    @Override
    protected int compareToSameClass(Object o) {
        LinearRing thisShell = this.shell;
        LinearRing otherShell = ((Polygon)o).shell;
        return thisShell.compareToSameClass(otherShell);
    }

    @Override
    protected int compareToSameClass(Object o, CoordinateSequenceComparator comp) {
        int i;
        Polygon poly = (Polygon)o;
        LinearRing thisShell = this.shell;
        LinearRing otherShell = poly.shell;
        int shellComp = thisShell.compareToSameClass(otherShell, comp);
        if (shellComp != 0) {
            return shellComp;
        }
        int nHole1 = this.getNumInteriorRing();
        int nHole2 = poly.getNumInteriorRing();
        for (i = 0; i < nHole1 && i < nHole2; ++i) {
            LinearRing otherHole;
            LinearRing thisHole = (LinearRing)this.getInteriorRingN(i);
            int holeComp = thisHole.compareToSameClass(otherHole = (LinearRing)poly.getInteriorRingN(i), comp);
            if (holeComp == 0) continue;
            return holeComp;
        }
        if (i < nHole1) {
            return 1;
        }
        if (i < nHole2) {
            return -1;
        }
        return 0;
    }

    private static void normalize(LinearRing ring, boolean clockwise) {
        if (ring.isEmpty()) {
            return;
        }
        Coordinate[] uniqueCoordinates = new Coordinate[ring.getCoordinates().length - 1];
        System.arraycopy(ring.getCoordinates(), 0, uniqueCoordinates, 0, uniqueCoordinates.length);
        Coordinate minCoordinate = CoordinateArrays.minCoordinate(ring.getCoordinates());
        CoordinateArrays.scroll(uniqueCoordinates, minCoordinate);
        System.arraycopy(uniqueCoordinates, 0, ring.getCoordinates(), 0, uniqueCoordinates.length);
        ring.getCoordinates()[uniqueCoordinates.length] = uniqueCoordinates[0];
        if (CGAlgorithms.isCCW(ring.getCoordinates()) == clockwise) {
            CoordinateArrays.reverse(ring.getCoordinates());
        }
    }

    @Override
    public Geometry reverse() {
        Polygon poly = (Polygon)super.clone();
        poly.shell = (LinearRing)((LinearRing)this.shell.clone()).reverse();
        poly.holes = new LinearRing[this.holes.length];
        for (int i = 0; i < this.holes.length; ++i) {
            poly.holes[i] = (LinearRing)((LinearRing)this.holes[i].clone()).reverse();
        }
        return poly;
    }

    @Override
    public Geometry getGeometryN(int n) {
        return this;
    }
}

