/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class PrecisionModel
implements Serializable,
Comparable<PrecisionModel> {
    private static final long serialVersionUID = 7777263578777803835L;
    public static final Type FIXED = new Type("FIXED");
    public static final Type FLOATING = new Type("FLOATING");
    public static final Type FLOATING_SINGLE = new Type("FLOATING SINGLE");
    public static final double maximumPreciseValue = 9.007199254740992E15;
    private Type modelType;
    private double scale;

    public static PrecisionModel mostPrecise(PrecisionModel pm1, PrecisionModel pm2) {
        if (pm1.compareTo(pm2) >= 0) {
            return pm1;
        }
        return pm2;
    }

    public PrecisionModel() {
        this.modelType = FLOATING;
    }

    public PrecisionModel(Type modelType) {
        this.modelType = modelType;
        if (modelType == FIXED) {
            this.setScale(1.0);
        }
    }

    public PrecisionModel(double scale) {
        this.modelType = FIXED;
        this.setScale(scale);
    }

    public PrecisionModel(PrecisionModel pm) {
        this.modelType = pm.modelType;
        this.scale = pm.scale;
    }

    public boolean isFloating() {
        return this.modelType == FLOATING || this.modelType == FLOATING_SINGLE;
    }

    public int getMaximumSignificantDigits() {
        int maxSigDigits = 16;
        if (this.modelType == FLOATING) {
            maxSigDigits = 16;
        } else if (this.modelType == FLOATING_SINGLE) {
            maxSigDigits = 6;
        } else if (this.modelType == FIXED) {
            maxSigDigits = 1 + (int)Math.ceil(Math.log(this.getScale()) / Math.log(10.0));
        }
        return maxSigDigits;
    }

    public double getScale() {
        return this.scale;
    }

    public Type getType() {
        return this.modelType;
    }

    private void setScale(double scale) {
        this.scale = Math.abs(scale);
    }

    public double makePrecise(double val) {
        if (Double.isNaN(val)) {
            return val;
        }
        if (this.modelType == FLOATING_SINGLE) {
            float floatSingleVal = (float)val;
            return floatSingleVal;
        }
        if (this.modelType == FIXED) {
            return (double)Math.round(val * this.scale) / this.scale;
        }
        return val;
    }

    public void makePrecise(Coordinate coord) {
        if (this.modelType == FLOATING) {
            return;
        }
        coord.x = this.makePrecise(coord.x);
        coord.y = this.makePrecise(coord.y);
    }

    public String toString() {
        String description = "UNKNOWN";
        if (this.modelType == FLOATING) {
            description = "Floating";
        } else if (this.modelType == FLOATING_SINGLE) {
            description = "Floating-Single";
        } else if (this.modelType == FIXED) {
            description = "Fixed (Scale=" + this.getScale() + ")";
        }
        return description;
    }

    public boolean equals(Object other) {
        if (!(other instanceof PrecisionModel)) {
            return false;
        }
        PrecisionModel otherPrecisionModel = (PrecisionModel)other;
        return this.modelType == otherPrecisionModel.modelType && this.scale == otherPrecisionModel.scale;
    }

    @Override
    public int compareTo(PrecisionModel other) {
        int sigDigits = this.getMaximumSignificantDigits();
        int otherSigDigits = other.getMaximumSignificantDigits();
        return new Integer(sigDigits).compareTo(new Integer(otherSigDigits));
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static class Type
    implements Serializable {
        private static final long serialVersionUID = -5528602631731589822L;
        private static Map<String, Type> nameToTypeMap = new HashMap<String, Type>();
        private String name;

        public Type(String name) {
            this.name = name;
            nameToTypeMap.put(name, this);
        }

        public String toString() {
            return this.name;
        }

        private Object readResolve() {
            return nameToTypeMap.get(this.name);
        }
    }
}

