/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.util;

import com.vividsolutions.jts.geom.Coordinate;

public class Angle {
    public static final double PI_TIMES_2 = Math.PI * 2;
    public static final double PI_OVER_2 = 1.5707963267948966;
    public static final double PI_OVER_4 = 0.7853981633974483;
    public static final int COUNTERCLOCKWISE = 1;
    public static final int CLOCKWISE = -1;
    public static final int NONE = 0;

    public static double toDegrees(double radians) {
        return radians * 180.0 / Math.PI;
    }

    public static double toRadians(double angleDegrees) {
        return angleDegrees * Math.PI / 180.0;
    }

    public static double angle(Coordinate p0, Coordinate p1) {
        double dx = p1.x - p0.x;
        double dy = p1.y - p0.y;
        return Math.atan2(dy, dx);
    }

    public static double angle(Coordinate p) {
        return Math.atan2(p.y, p.x);
    }

    public static boolean isAcute(Coordinate p0, Coordinate p1, Coordinate p2) {
        double dx0 = p0.x - p1.x;
        double dx1 = p2.x - p1.x;
        double dy0 = p0.y - p1.y;
        double dy1 = p2.y - p1.y;
        double dotprod = dx0 * dx1 + dy0 * dy1;
        return dotprod > 0.0;
    }

    public static boolean isObtuse(Coordinate p0, Coordinate p1, Coordinate p2) {
        double dx0 = p0.x - p1.x;
        double dx1 = p2.x - p1.x;
        double dy0 = p0.y - p1.y;
        double dy1 = p2.y - p1.y;
        double dotprod = dx0 * dx1 + dy0 * dy1;
        return dotprod < 0.0;
    }

    public static double angleBetween(Coordinate tip1, Coordinate tail, Coordinate tip2) {
        double a1 = Angle.angle(tail, tip1);
        double a2 = Angle.angle(tail, tip2);
        return Angle.diff(a1, a2);
    }

    public static double angleBetweenOriented(Coordinate tip1, Coordinate tail, Coordinate tip2) {
        double a1 = Angle.angle(tail, tip1);
        double a2 = Angle.angle(tail, tip2);
        double angDel = a2 - a1;
        if (angDel <= -Math.PI) {
            return angDel + Math.PI * 2;
        }
        if (angDel > Math.PI) {
            return angDel - Math.PI * 2;
        }
        return angDel;
    }

    public static double interiorAngle(Coordinate p0, Coordinate p1, Coordinate p2) {
        double anglePrev = Angle.angle(p1, p0);
        double angleNext = Angle.angle(p1, p2);
        return Math.abs(angleNext - anglePrev);
    }

    public static int getTurn(double ang1, double ang2) {
        double crossproduct = Math.sin(ang2 - ang1);
        if (crossproduct > 0.0) {
            return 1;
        }
        if (crossproduct < 0.0) {
            return -1;
        }
        return 0;
    }

    public static double normalize(double angle_) {
        double angle;
        for (angle = angle_; angle > Math.PI; angle -= Math.PI * 2) {
        }
        while (angle <= -Math.PI) {
            angle += Math.PI * 2;
        }
        return angle;
    }

    public static double normalizePositive(double angle_) {
        double angle = angle_;
        if (angle < 0.0) {
            while (angle < 0.0) {
                angle += Math.PI * 2;
            }
            if (angle >= Math.PI * 2) {
                angle = 0.0;
            }
        } else {
            while (angle >= Math.PI * 2) {
                angle -= Math.PI * 2;
            }
            if (angle < 0.0) {
                angle = 0.0;
            }
        }
        return angle;
    }

    public static double diff(double ang1, double ang2) {
        double delAngle = ang1 < ang2 ? ang2 - ang1 : ang1 - ang2;
        if (delAngle > Math.PI) {
            delAngle = Math.PI * 2 - delAngle;
        }
        return delAngle;
    }
}

