/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.util.extracter;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LinearComponentExtracter
implements GeometryComponentFilter {
    private Collection<LineString> lines;
    private boolean isForcedToLineString = false;

    public static List<LineString> getLines(Geometry geom) {
        return LinearComponentExtracter.getLines(geom, false);
    }

    public static List<LineString> getLines(Geometry geom, boolean forceToLineString) {
        ArrayList<LineString> lines = new ArrayList<LineString>();
        geom.apply(new LinearComponentExtracter(lines, forceToLineString));
        return lines;
    }

    public LinearComponentExtracter(Collection<LineString> lines) {
        this.lines = lines;
    }

    public LinearComponentExtracter(Collection<LineString> lines, boolean isForcedToLineString) {
        this.lines = lines;
        this.isForcedToLineString = isForcedToLineString;
    }

    public void setForceToLineString(boolean isForcedToLineString) {
        this.isForcedToLineString = isForcedToLineString;
    }

    @Override
    public void filter(Geometry geom) {
        if (this.isForcedToLineString && geom instanceof LinearRing) {
            LineString line = geom.getFactory().createLineString(((LinearRing)geom).getCoordinateSequence());
            this.lines.add(line);
            return;
        }
        if (geom instanceof LineString) {
            this.lines.add((LineString)geom);
        }
    }
}

