/*
 * Decompiled with CFR 0.152.
 */
package org.opencarto.algo;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import org.opencarto.algo.Orientation;
import org.opencarto.algo.deformation.Decomposers;
import org.opencarto.algo.deformation.GDeformable;
import org.opencarto.algo.deformation.constraint.SegmentLength;
import org.opencarto.algo.deformation.constraint.SegmentOrientation;
import org.opencarto.algo.deformation.submicro.GSegment;

public class Squarring {
    public static Polygon get(Polygon poly) {
        return Squarring.get(poly, 20.0, -1, 0.01);
    }

    public static Polygon get(Polygon poly, double angleToleranceDeg, int pointActivationLimitNb, double res) {
        Polygon poly2 = (Polygon)poly.clone();
        GDeformable def = Decomposers.decomposeLimit((Polygon)poly2, (double)res, (boolean)false);
        double o = new Orientation((Geometry)poly2).getSidesOrientation();
        for (GSegment s : def.getSegments()) {
            s.getConstraints().add(new SegmentLength(s, 1.0));
            double so = s.getOrientation();
            double segOrientationModuloHalfPi = 0.0;
            if (so < -1.5707963267948966) {
                segOrientationModuloHalfPi = so + Math.PI;
            } else if (so >= -1.5707963267948966 && so < 0.0) {
                segOrientationModuloHalfPi = so + 1.5707963267948966;
            } else if (so >= 0.0 && so < 1.5707963267948966) {
                segOrientationModuloHalfPi = so;
            } else if (so > 1.5707963267948966) {
                segOrientationModuloHalfPi = so - 1.5707963267948966;
            }
            if (so == Math.PI) {
                segOrientationModuloHalfPi = 0.0;
            }
            if (Math.abs(segOrientationModuloHalfPi - o) * 180.0 / Math.PI <= angleToleranceDeg) {
                double so2 = 0.0;
                if (so < -1.5707963267948966) {
                    so2 = o - Math.PI;
                } else if (so >= -1.5707963267948966 && so < 0.0) {
                    so2 = o - 1.5707963267948966;
                } else if (so >= 0.0 && so < 1.5707963267948966) {
                    so2 = o;
                } else if (so > 1.5707963267948966) {
                    so2 = o + 1.5707963267948966;
                }
                if (so == Math.PI) {
                    so2 = 0.0;
                }
                s.getConstraints().add(new SegmentOrientation(s, 10.0, so2));
                continue;
            }
            s.getConstraints().add(new SegmentOrientation(s, 2.0));
        }
        def.loadNonBalancedPoints();
        def.activatePoints(pointActivationLimitNb * def.getPoints().size());
        if (!IsValidOp.isValid((Geometry)def.getGeom())) {
            return poly;
        }
        if (def.getGeom().isEmpty()) {
            return poly;
        }
        if (def.getGeom().getArea() < 1.0E-4) {
            return poly;
        }
        def.clean();
        return poly2;
    }
}

