/*
 * Decompiled with CFR 0.152.
 */
package org.opencarto.algo;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import org.opencarto.algo.SmallestSurroundingRectangle;

public class Orientation {
    private static int TESTED_ORIENTATIONS_NB = 30;
    private Geometry geom = null;
    private double[] votes = null;
    private double sidesOrientation = -999.9;
    private double maxVote = -999.9;
    private double sidesOrientationIndicator = -999.9;

    public Orientation(Geometry geom) {
        this.geom = geom;
    }

    public double[] getVotes() {
        if (this.votes == null) {
            this.computeVotes((Polygon)this.geom);
        }
        return this.votes;
    }

    public double getSidesOrientation() {
        if (this.sidesOrientation == -999.9) {
            this.computeSidesOrientation();
        }
        return this.sidesOrientation;
    }

    public double getSidesOrientationIndicator() {
        if (this.sidesOrientationIndicator == -999.9) {
            this.computeSidesOrientationIndicator();
        }
        return this.sidesOrientationIndicator;
    }

    public double getGeneralOrientation() {
        Coordinate c2;
        Coordinate c1;
        double lg2;
        Polygon ssr = SmallestSurroundingRectangle.get((Geometry)this.geom);
        if (ssr == null) {
            return 999.9;
        }
        Coordinate[] coords = ssr.getCoordinates();
        double lg1 = coords[0].distance(coords[1]);
        if (lg1 == (lg2 = coords[1].distance(coords[2]))) {
            return 999.9;
        }
        if (lg1 > lg2) {
            c1 = coords[0];
            c2 = coords[1];
        } else {
            c1 = coords[1];
            c2 = coords[2];
        }
        double angle = Math.atan((c1.y - c2.y) / (c1.x - c2.x));
        if (angle < 0.0) {
            angle += Math.PI;
        }
        return angle;
    }

    private void computeSidesOrientation() {
        double vote;
        if (this.votes == null) {
            this.computeVotes();
        }
        int iMax = 0;
        this.maxVote = vote = this.votes[iMax];
        for (int i = 1; i < this.votes.length; ++i) {
            vote = this.votes[i];
            if (!(vote > this.maxVote)) continue;
            this.maxVote = vote;
            iMax = i;
        }
        this.sidesOrientation = 1.5707963267948966 * (double)iMax / (double)TESTED_ORIENTATIONS_NB;
    }

    private void computeVotes() {
        if (this.geom instanceof Polygon) {
            this.computeVotes((Polygon)this.geom);
        } else if (this.geom instanceof LineString) {
            this.computeVotes((LineString)this.geom);
        } else {
            this.sidesOrientation = -999.9;
            return;
        }
    }

    private void computeVotes(Polygon poly) {
        int i;
        this.votes = new double[TESTED_ORIENTATIONS_NB];
        for (i = 0; i < TESTED_ORIENTATIONS_NB; ++i) {
            this.votes[i] = 0.0;
        }
        this.addVotes(poly.getExteriorRing());
        for (i = 0; i < poly.getNumInteriorRing(); ++i) {
            this.addVotes(poly.getInteriorRingN(i));
        }
    }

    private void computeVotes(LineString ls) {
        this.votes = new double[TESTED_ORIENTATIONS_NB];
        for (int i = 0; i < TESTED_ORIENTATIONS_NB; ++i) {
            this.votes[i] = 0.0;
        }
        this.addVotes(ls);
    }

    private void addVotes(LineString ls) {
        Coordinate[] coord = ls.getCoordinates();
        Coordinate c1 = coord[0];
        double pasOrientation = 1.5707963267948966 / (double)TESTED_ORIENTATIONS_NB;
        for (int i = 1; i < coord.length; ++i) {
            Coordinate c2 = coord[i];
            double orientation = c1.x == c2.x ? 0.0 : Math.atan((c1.y - c2.y) / (c1.x - c2.x));
            if (orientation < 0.0) {
                orientation += 1.5707963267948966;
            }
            int index = (int)(orientation / pasOrientation);
            double lg = c1.distance(c2);
            double delta = orientation / pasOrientation - (double)index;
            int n = index;
            this.votes[n] = this.votes[n] + lg * (1.0 - delta);
            if (index + 1 == TESTED_ORIENTATIONS_NB) {
                this.votes[0] = this.votes[0] + lg * delta;
            } else {
                int n2 = index + 1;
                this.votes[n2] = this.votes[n2] + lg * delta;
            }
            c1 = c2;
        }
    }

    private void computeSidesOrientationIndicator() {
        if (this.sidesOrientation == -999.9) {
            this.computeSidesOrientation();
        }
        this.sidesOrientationIndicator = this.maxVote / this.geom.getLength();
    }
}

