/*
 * Decompiled with CFR 0.152.
 */
package org.opencarto.algo.deformation;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opencarto.algo.deformation.GDeformable;
import org.opencarto.algo.deformation.GPoint;
import org.opencarto.algo.deformation.submicro.GAngle;
import org.opencarto.algo.deformation.submicro.GSegment;
import org.opencarto.algo.deformation.submicro.GSinglePoint;

public class Decomposers {
    private static Logger logger = Logger.getLogger(Decomposers.class.getName());

    public static GDeformable decomposeLimit(Polygon poly, double resolution) {
        return Decomposers.decomposeLimit(poly, resolution, false);
    }

    public static GDeformable decomposeLimit(Polygon poly, double resolution, boolean buildAngles) {
        GDeformable def = new GDeformable((Geometry)poly, resolution);
        Decomposers.decomposerDPL(def, poly.getExteriorRing().getCoordinates(), buildAngles);
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            Decomposers.decomposerDPL(def, poly.getInteriorRingN(i).getCoordinates(), buildAngles);
        }
        return def;
    }

    public static GDeformable decompose(LineString line, double resolution) {
        return Decomposers.decompose(line, resolution, false);
    }

    public static GDeformable decompose(LineString line, double resolution, boolean buildAngles) {
        GDeformable def = new GDeformable((Geometry)line, resolution);
        Decomposers.decomposerDPL(def, line.getCoordinates(), buildAngles);
        return def;
    }

    public static void createSinglePoints(GDeformable def) {
        for (GPoint p : def.getPoints()) {
            def.getSinglePoints().add(new GSinglePoint(p));
        }
    }

    private static void decomposerDPL(GDeformable def, Coordinate[] coords, boolean buildAngles) {
        int nb = coords.length;
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "points nb=" + nb);
        }
        if (nb < 2) {
            logger.severe("Error when decomposing in " + def + ". Coordinates list must have more than 2 points.");
            logger.severe(coords.toString());
            return;
        }
        GPoint p0 = new GPoint(def, coords[0]);
        def.getPoints().add(p0);
        GPoint p1 = new GPoint(def, coords[1]);
        def.getPoints().add(p1);
        def.getSegments().add(new GSegment(p0, p1));
        GPoint p0_ = p0;
        GPoint p1_ = p1;
        GPoint p2 = null;
        for (int i = 2; i < nb - 1; ++i) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "(" + coords[i].x + ", " + coords[i].y + ")");
            }
            p2 = new GPoint(def, coords[i]);
            def.getPoints().add(p2);
            def.getSegments().add(new GSegment(p1, p2));
            if (buildAngles) {
                def.getAngles().add(new GAngle(p0, p1, p2));
            }
            p0 = p1;
            p1 = p2;
        }
        boolean closed = coords[0].distance(coords[nb - 1]) <= def.resolution;
        if (closed) {
            def.getSegments().add(new GSegment(p1, p0_));
            if (buildAngles) {
                def.getAngles().add(new GAngle(p0, p1, p0_));
                def.getAngles().add(new GAngle(p1, p0_, p1_));
            }
            if (coords[0] != coords[nb - 1]) {
                p0_.getCoordinates().add(coords[nb - 1]);
            }
        } else {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "(" + coords[nb - 1].x + ", " + coords[nb - 1].y + ")");
            }
            p2 = new GPoint(def, coords[nb - 1]);
            def.getPoints().add(p2);
            def.getSegments().add(new GSegment(p1, p2));
            if (buildAngles) {
                def.getAngles().add(new GAngle(p0, p1, p2));
            }
        }
    }
}

