/*
 * Decompiled with CFR 0.152.
 */
package org.opencarto.algo.deformation;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opencarto.algo.deformation.GPoint;
import org.opencarto.algo.deformation.Submicro;
import org.opencarto.algo.deformation.submicro.GAngle;
import org.opencarto.algo.deformation.submicro.GSegment;
import org.opencarto.algo.deformation.submicro.GSinglePoint;
import org.opencarto.algo.deformation.submicro.GTriangle;

public class GDeformable {
    private static Logger logger = Logger.getLogger(GDeformable.class.getName());
    private Geometry geom;
    double resolution;
    private HashSet<GPoint> pts = new HashSet();
    private HashSet<GSinglePoint> sps = new HashSet();
    private HashSet<GSegment> segs = new HashSet();
    private HashSet<GTriangle> tris = new HashSet();
    private HashSet<GAngle> angles = new HashSet();
    private ArrayList<GPoint> activationStack = new ArrayList();

    public GDeformable(Geometry geom, double resolution) {
        this.geom = geom;
        this.resolution = resolution;
    }

    public Geometry getGeom() {
        return this.geom;
    }

    public HashSet<GPoint> getPoints() {
        return this.pts;
    }

    public HashSet<GPoint> getPoints(Coordinate c) {
        HashSet<GPoint> pts_ = new HashSet<GPoint>();
        for (GPoint pt : this.getPoints()) {
            if (pt.getPosition().x != c.x || pt.getPosition().y != c.y) continue;
            pts_.add(pt);
        }
        return pts_;
    }

    public HashSet<GSinglePoint> getSinglePoints() {
        return this.sps;
    }

    public HashSet<GSegment> getSegments() {
        return this.segs;
    }

    public HashSet<GTriangle> getTriangles() {
        return this.tris;
    }

    public HashSet<GAngle> getAngles() {
        return this.angles;
    }

    public ArrayList<GPoint> getActivationStack() {
        return this.activationStack;
    }

    public void loadNonBalancedPoints() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Load non balanced points of " + this);
        }
        this.getActivationStack().clear();
        Coordinate c0 = new Coordinate(0.0, 0.0);
        for (GPoint p : this.getPoints()) {
            Coordinate dis;
            if (p.isFrozen() || !((dis = p.getdisplacement()).distance(c0) > this.resolution * 0.5)) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(p + " added");
            }
            this.getActivationStack().add(p);
        }
    }

    public void activatePoints() {
        this.activatePoints(-1);
    }

    public void activatePoints(int max) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Activation of the points of " + this + " (" + this.getActivationStack().size() + " initial non-balanced points).");
        }
        int i = 0;
        Coordinate c0 = new Coordinate(0.0, 0.0);
        while (true) {
            if (this.getActivationStack().isEmpty()) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("No more point to activate: deformation terminated.");
                }
                return;
            }
            if (max > 0 && i >= max) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Limit number of activation reached: deformation stopped.");
                }
                return;
            }
            ++i;
            GPoint p = this.getActivationStack().get((int)((double)this.getActivationStack().size() * Math.random()));
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Activation of " + p);
            }
            Coordinate dis = p.getdisplacement();
            double length = dis.distance(c0);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Displacement: " + dis.x + "," + dis.y + " - length=" + length);
            }
            if (length < this.resolution * 0.5) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("point balanced");
                }
                this.getActivationStack().remove(p);
                continue;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("point displaced");
            }
            p.displace(dis);
            double length_ = p.getdisplacement().distance(c0);
            if (length_ > length) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("   no improvement: go back and remove");
                }
                p.displace(new Coordinate(-dis.x, -dis.y));
                this.getActivationStack().remove(p);
                continue;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("   improvement: diffuse to neigbours");
            }
            p.diffuse();
        }
    }

    public void clean() {
        this.deleteConstraints();
        for (GPoint p : this.getPoints()) {
            for (Submicro sm : p.getSubmicros()) {
                sm.clean();
            }
            p.clean();
        }
        if (this.getActivationStack() != null) {
            this.getActivationStack().clear();
        }
        if (this.getPoints() != null) {
            this.getPoints().clear();
        }
        if (this.getSinglePoints() != null) {
            this.getSinglePoints().clear();
        }
        if (this.getSegments() != null) {
            this.getSegments().clear();
        }
        if (this.getAngles() != null) {
            this.getAngles().clear();
        }
        if (this.getTriangles() != null) {
            this.getTriangles().clear();
        }
    }

    private void deleteConstraints() {
        for (GSinglePoint ps_ : this.getSinglePoints()) {
            ps_.getConstraints().clear();
        }
        for (GSegment s : this.getSegments()) {
            s.getConstraints().clear();
        }
        for (GTriangle t : this.getTriangles()) {
            t.getConstraints().clear();
        }
        for (GAngle a : this.getAngles()) {
            a.getConstraints().clear();
        }
    }
}

