/*
 * Decompiled with CFR 0.152.
 */
package org.opencarto.algo.deformation;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opencarto.algo.deformation.GConstraint;
import org.opencarto.algo.deformation.GDeformable;
import org.opencarto.algo.deformation.Submicro;
import org.opencarto.algo.deformation.submicro.GSegment;

public class GPoint {
    private static Logger logger = Logger.getLogger(GPoint.class.getName());
    private GDeformable def;
    private ArrayList<Coordinate> coordinates = new ArrayList();
    private Coordinate cIni;
    private ArrayList<GConstraint> constraints = new ArrayList();
    private ArrayList<Submicro> submicros = new ArrayList();
    private ArrayList<GPoint> prs = new ArrayList();
    private boolean frozen = false;
    double is = -1.0;

    public GPoint(GDeformable def, Coordinate dp) {
        this.def = def;
        this.getCoordinates().add(dp);
        this.cIni = new Coordinate(dp.x, dp.y, dp.z);
    }

    public GDeformable getDeformable() {
        return this.def;
    }

    public ArrayList<Coordinate> getCoordinates() {
        return this.coordinates;
    }

    public Coordinate getPosition() {
        return this.coordinates.get(0);
    }

    public double getX() {
        return this.getCoordinates().get((int)0).x;
    }

    public void setX(double x) {
        for (Coordinate c : this.getCoordinates()) {
            c.x = x;
        }
    }

    public double getY() {
        return this.getCoordinates().get((int)0).y;
    }

    public void setY(double y) {
        for (Coordinate c : this.getCoordinates()) {
            c.y = y;
        }
    }

    public Coordinate getInitialPosition() {
        return this.cIni;
    }

    public double getXIni() {
        return this.getInitialPosition().x;
    }

    public double getYIni() {
        return this.getInitialPosition().y;
    }

    public ArrayList<GConstraint> getConstraints() {
        return this.constraints;
    }

    public ArrayList<Submicro> getSubmicros() {
        return this.submicros;
    }

    public ArrayList<GPoint> getPointsRel() {
        return this.prs;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void setFrozen(boolean f) {
        this.frozen = f;
    }

    public Coordinate getdisplacement() {
        Coordinate dis = new Coordinate(0.0, 0.0);
        for (GConstraint gc : this.getConstraints()) {
            Coordinate c = gc.getDisplacement(this);
            if (c == null) {
                logger.severe(gc.getClass().getSimpleName() + " has returned a null displacement.");
                continue;
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "  Constraint: " + gc.getClass().getSimpleName() + " - displacment: (" + c.x + ", " + c.y + ")");
            }
            dis.x += c.x;
            dis.y += c.y;
        }
        return dis;
    }

    public double getImportanceSum() {
        if (this.is == -1.0) {
            this.is = 0.0;
            for (GConstraint gc : this.getConstraints()) {
                this.is += gc.getImportance();
            }
        }
        return this.is;
    }

    public void displace(Coordinate dis) {
        this.setX(this.getX() + dis.x);
        this.setY(this.getY() + dis.y);
    }

    protected void diffuse() {
        for (GPoint p : this.getPointsRel()) {
            if (p.isFrozen() || this.getDeformable().getActivationStack().contains(p)) continue;
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "add " + p);
            }
            this.getDeformable().getActivationStack().add(p);
        }
    }

    public double getDistance(double x_, double y_) {
        return Math.hypot(this.getX() - x_, this.getY() - y_);
    }

    public double getDistance(GPoint p) {
        return this.getDistance(p.getX(), p.getY());
    }

    public double getDistance(GSegment s) {
        if ((s.getPt2().getX() - s.getPt1().getX()) * (this.getX() - s.getPt1().getX()) + (s.getPt2().getY() - s.getPt1().getY()) * (this.getY() - s.getPt1().getY()) <= 0.0) {
            return this.getDistance(s.getPt1());
        }
        if ((s.getPt1().getX() - s.getPt2().getX()) * (this.getX() - s.getPt2().getX()) + (s.getPt1().getY() - s.getPt2().getY()) * (this.getY() - s.getPt2().getY()) <= 0.0) {
            return this.getDistance(s.getPt2());
        }
        return Math.abs(((s.getPt1().getX() - this.getX()) * (s.getPt1().getY() - s.getPt2().getY()) + (s.getPt1().getY() - this.getY()) * (s.getPt2().getX() - s.getPt1().getX())) / Math.sqrt(Math.pow(s.getPt2().getX() - s.getPt1().getX(), 2.0) + Math.pow(s.getPt2().getY() - s.getPt1().getY(), 2.0)));
    }

    public Coordinate getProjected(GSegment s) {
        double ps = (s.getPt2().getX() - s.getPt1().getX()) * (this.getX() - s.getPt1().getX()) + (s.getPt2().getY() - s.getPt1().getY()) * (this.getY() - s.getPt1().getY());
        double dc = Math.pow(s.getPt2().getX() - s.getPt1().getX(), 2.0) + Math.pow(s.getPt2().getY() - s.getPt1().getY(), 2.0);
        return new Coordinate(s.getPt1().getX() + ps * (s.getPt2().getX() - s.getPt1().getX()) / dc, s.getPt1().getY() + ps * (s.getPt2().getY() - s.getPt1().getY()) / dc);
    }

    public double getIniDistance(double x_, double y_) {
        return Math.sqrt((this.getXIni() - x_) * (this.getXIni() - x_) + (this.getYIni() - y_) * (this.getYIni() - y_));
    }

    public double getIniDistance(GPoint p) {
        return this.getIniDistance(p.getXIni(), p.getYIni());
    }

    public double getDistanceToInitialPosition() {
        return Math.sqrt((this.getXIni() - this.getX()) * (this.getXIni() - this.getX()) + (this.getYIni() - this.getY()) * (this.getYIni() - this.getY()));
    }

    public double getOrientation(GPoint p) {
        return Math.atan2(p.getY() - this.getY(), p.getX() - this.getX());
    }

    public double getIniOrientation(GPoint p) {
        return Math.atan2(p.getYIni() - this.getYIni(), p.getXIni() - this.getXIni());
    }

    public double getOrientationGap(GPoint p) {
        double ecart = this.getOrientation(p) - this.getIniOrientation(p);
        if (ecart < -Math.PI) {
            return ecart + Math.PI * 2;
        }
        if (ecart > Math.PI) {
            return ecart - Math.PI * 2;
        }
        return ecart;
    }

    public void clean() {
        if (this.getConstraints() != null) {
            this.getConstraints().clear();
        }
        this.getPointsRel().clear();
        this.getSubmicros().clear();
    }
}

